(ns {{name}}.config
    (:require [environ.core :refer [env]]
              [clojure.tools.logging :as log]))

(defonce params (atom nil))

(defn load-env []
  (log/info "Loading environment vars")
  (swap! params assoc
         :db-url (or (:db-url env) (str "mongodb://localhost:27017/" "{{name}}"))
         :env (:env env)
         :server-port (Integer. (or (:port env) 8000))
         :host (str (:server-host @params) ":" (:port @params))
         :nrepl-port (Integer. (or (:nrepl-port env) 8100))))

(defn access [config-atom k]
  (fn []
    (get @params k)))

(def db-url                 (access params :db-url))
(def server-port            (access params :server-port))
(def nrepl-port             (access params :nrepl-port))
(def envi                   (access params :env))
