(ns {{name}}.router
    (:require [environ.core :refer [env]]
              [clojure.java.io :as io]
              [clojure.tools.logging :as log]
              [ring.middleware.content-type :refer :all]
              [ring.middleware.edn :refer :all]
              [ring.middleware.keyword-params :as keyword-params]
              [ring.middleware.params :as params]
              [ring.middleware.resource :refer :all]
              [ring.middleware.session :as session]
              [ring.middleware.session.cookie :as cookie]
              [ring.middleware.nested-params :as nested-params]
              [ring.middleware.content-type :refer :all]
              [ring.middleware.not-modified :refer :all]
              [ring.util.response :refer :all]
              [compojure.core :refer [context defroutes GET PUT POST DELETE ANY]]
              [compojure.route :as route]
              [prone.debug :refer [debug]]
              [org.httpkit.server :as server]
              [{{name}}.data :as db])
    (:import java.net.URI))

(defn edn-response [data & [status]]
  {:status (or status 200)
   :headers {"Content-Type" "application/edn"}
   :body (pr-str data)})

(defn resolve-uri [context uri]
  (let [context (if (instance? URI context) context (URI. context))]
    (.resolve context uri)))

(defn- context-uri
  "Resolves a [uri] against the :context URI (if found) in the provided
  Ring request. Useful in conjunction with compojure.core/context."
  [{:keys [context]} uri]
  (if-let [base (and context (str context "/"))]
    (str (resolve-uri base uri))
    uri))

(defn handle-websocket [req]
  (server/with-channel req con
    (log/info "Connection from" con)
    (server/on-receive con #(server/send! con (str "Echo: " %)))
    (server/on-close con (fn [status]
                           (log/info con "Disconnected ws with status" (name status))))))

(defroutes routes
  (GET "/" [] (str "Server is running"))
  (GET "/ws" [] handle-websocket)
  (context
      "/api" []
      (GET "/languages" []
           (let [prog (get-in db/data [:languages])]
             (when prog
               (edn-response prog))))
      (POST "/messages" [msg :as request]
            (response str))

      (GET "/languages/:id/:type" [id type]
           (let [stats (filter #(and
                                 (= (:id %) id) (= (:type %) type))
                               (get-in db/data [:stats]))]
             (when stats
               (response stats))))))
