(ns {{ns-name}}.core
  (:import java.io.File)
  (:use clojure.pprint)
  (:use ring.adapter.jetty)
  (:use ring.util.response)
  (:use ring.middleware.reload)
  (:use ring.middleware.stacktrace))

(defonce cwd (.getCanonicalPath (File. ".")))
(println "Current directory: " cwd)

(defn handler [req]
  (pprint (:uri req))
  ;; (pprint (str cwd "/index.html"))
  (condp = (:uri req)
    "/" (file-response (str cwd "/index.html"))
    (file-response (str cwd (:uri req)))))

(def app
  (-> #'handler
   (wrap-reload)))

(defn boot []
  (run-jetty #'app {:port 8080}))
