(ns ritz.nrepl.add-thread-id
  (:require
   [clojure.tools.nrepl.transport :as transport])
  (:import clojure.tools.nrepl.transport.Transport))

(defn add-thread-id
  "Middleware that returns a handler which adds a :thread-id slot
   in messages sent via the request's Transport with a :status slot,
   delegating all actual message handling to the provided handler."
  [h]
  (fn [{:keys [op ^Transport transport] :as msg}]
    (h (assoc msg
         :transport (reify Transport
                      (recv [this] (.recv transport))
                      (recv [this timeout] (.recv transport timeout))
                      (send [this resp]
                        (.send transport
                               (if-let [[_ v] (find resp :status)]
                                 (assoc resp
                                   :thread-id
                                   (.. (Thread/currentThread) getId))
                                 resp))))))))
