(ns snabbdom.core
  (:require
   [clojure.walk :refer [postwalk]]
   [snabbdom]))

(def patch (.-patch snabbdom/snabbdomBundle))
(def sd-h (.-h snabbdom/snabbdomBundle))

(defn h
  "wrap snabbdom's h function. specify keyword for html element,
  data for its style and other data, content for text or children"
  ([k content]
   (h k {} content))
  ([k data content]
   (sd-h
    (name k)
    (clj->js data)
    (clj->js content))))

(defn vnode
  "Using hiccup-like data to define vnode"
  [v]
  (postwalk
   (fn [x]
     (if (vector? x)
       (let [[k & cs] x
             [data content]
             (if (map? (first cs)) [(first cs) (rest cs)] [{} cs])]
         (h k data content))
       x))
   v))


