# z

A simple Clojure wrapper around java.util.zip

## Usage

```clojure
  (ns ...
    (:require [rocks.clj.z.core :refer [compress]]))

  (compress "/Users/edvorg/Downloads/test.zip"
            :entries {"test.json" "test.json"})

  (compress "/Users/edvorg/Downloads/test.zip"
            :entries {"test.json" true})

  (compress "/Users/edvorg/Downloads/test.zip"
            :entries ["test.json"])

  ;; fully lazy mode, doesn't retain lazy seq
  (->> (io/file "/Users/edvorg/Projects/z")
       file-seq
       (filter #(.isFile %))
       (map #(.getPath %))
       constantly
       (compress "z.zip" :entries-fn))
```

## License

Copyright © 2017 Eduard Knyshov

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
