
(ns arr-xml.core)

(use 'rojat-arrows.hughes 'rojat-arrows.extra 'clojure.data.xml)

(defn arr-switch-elem [default-channel name channel & more]
 (arr-toggle-switch-inclusive (if (empty? more) default-channel (apply (partial arr-switch-elem default-channel) more)) 
                                           (fn[input] (and (= (:name input) name) (= (:type input) :start-element)))
                                           (fn[input] (and (= (:name input) name) (= (:type input) :end-element)))
                                           channel
 )
)
(defn arr-select-elem [name]
   (arr-switch-elem (arr-strict (fn [input] nil)) name h-id)
  )



(defn arr-select-path [name & more]
 (>>> (arr-select-elem name) (if (empty? more) h-id (apply arr-select-path more)))
)

(def arr-attributes (arr-strict (fn [input] (:attrs input))))

(def arr-characters (arr-strict (fn [input] (:str input))))


(def arr-stream-to-xml-seq (arr (fn [instream]
  ":: InputStream -> [XML]"
  (source-seq instream :coalescing false :namespace-aware true)
 ))
)



(defn start-element-to-zip [{name :name attrs :attrs}]
 (if attrs [name attrs] name)
)

(def arr-xml-to-zip
 
  (arr-accum [] (fn [stack input]

                                (case (:type input)
                                 :start-element (conj stack (start-element-to-zip input))
                                 :end-element (let [n (peek stack) s1 (pop stack) n1 (peek s1)] (conj (pop s1) (conj n1 n)))
                                 :characters (let [n (peek stack) n1 (conj n (:str input))] (conj (pop stack) n1))
                                 stack
                                 )
               )
               (fn [stack input] (and (= (:type input) :end-element) (= (ffirst stack) (:name input))))
   )
  
 
  
)
