
;tangled from rojat-arrhttp.org - do not modify
(ns rojat-arrhttp.core (:use rojat-arrows.extra rojat-arrows.hughes))

(def ^:dynamic *socket* nil)
(defmacro with-socket [socket body]
 `(do
   (alter-var-root #'*socket* (constantly ~socket))
   ~body
   (.close ~socket)
   )
)

(import [java.net InetSocketAddress Socket] [javax.net.ssl SSLSocketFactory])


(defn connect [server secure]
 (let [address (InetSocketAddress. (:host server) (:port server))
       socket (if secure (.createSocket (SSLSocketFactory/getDefault))
 (Socket.))
       c (.connect socket address)]

  socket  )
)

(import '[java.nio.channels Channels])
(defn request->buffer [request buffer]
  (let [bytes (.getBytes request)]
   (.flip (.put buffer bytes))
  )
)
(defn write-to-socket [socket buffer]
  (let [outStream (.getOutputStream socket)
        channel (Channels/newChannel outStream)]
   (loop []
     (.write channel buffer)
     (when (.hasRemaining buffer)
       (recur)
     )
    )
    (.flush outStream)
  )
)
(import '[java.nio ByteBuffer])
(defn arr-httpstream [socket]
  (arr (fn [request] 
      (let [buffer (ByteBuffer/allocate (* 16 1024))
            req_buf (request->buffer request buffer)
            in (.getInputStream socket)
            w (write-to-socket socket buffer)
        ]

    in
         )
    )
   )
)


 (import [java.net URLEncoder])
 
 (defn  wrap-query-params [params]
  (if params (reduce (fn [accum [k v]] (str accum (URLEncoder/encode
  (name k)) "=" (URLEncoder/encode v) "&")) "" (seq params)) params)
 )
 
 (def arr-apply-query-params-to-url 
  (arr (fn [method url
 header_fn body_fn url_params]
 
   [method (if url_params (str url "?" (wrap-query-params url_params))
 url) header_fn body_fn]))
 )
 
 (def arr-prepend-version 
  (arr (fn [method url header_fn body_fn]
 [(str "HTTP/1.1 " method) url header_fn body_fn]))
 )
 
 
 (def arr-content-length 
   (arr (fn [method url header-fn body-fn]
 
  (let [l (. (body-fn) length)
        header-fn1 (fn [] (assoc (header-fn) :Content-Length  l))]
   [method url header-fn1 body-fn])))
 )
 
 (require '[clojure.data.codec.base64 :as b64])
 (def arr-basic-authentication
  (arr (fn [credentials method url header-fn
 body-fn query-params]
  (let [user (:user credentials)
        password (:password credentials)
        userpass (str user ":" password)
        userpassenc (b64/encode (.getBytes userpass))
        headers-fn1 (fn [] (assoc (header-fn) :Authorization
  (str "Basic " (String. userpassenc "UTF8"))))]
   [method url headers-fn1 body-fn query-params]
 )))
 )
 
 (require '[oauth.client :as oauth]) 
 (def arr-oauth-authentication 
  (arr (fn [[credentials method url header-fn
 body-fn query-params]]
 
  (let [creds (oauth/credentials (:consumer credentials) (:token
 credentials) (:token_secret credentials) (:signature_method
 credentials) url query-params)
        oauth-headers (oauth/authorization-header creds)
        headers-fn1 (fn [] (merge (header-fn) oauth-headers))]
   [method url headers-fn1 body-fn query-params]
 
 )))
 
 )
 
 
 
 
 (def arr-noauth-authentication h-id)
 
 
 (def arr-authentication (arr-route-consume (partial = :basic)
 arr-basic-authentication (partial = :oauth) arr-oauth-authentication :otherwise arr-noauth-authentication))
 
 
 (defn- stringify-headers [header-fn]
  (reduce (fn [acc [k v]] (str acc (name k) ": " v "\n")) "" (seq (header-fn))) 
 )
 (def arr-stringify-request (arr (fn [method url header-fn body-fn]
  (str method " " url " HTTP/1.1\n" (stringify-headers header-fn) "\n" (body-fn))))
 )


(def arr-process-request
 (>>>
  arr-authentication
  ;[1 6] -> 5
  arr-apply-query-params-to-url
  ;5 ->4
 ; arr-prepend-version
  arr-content-length
  
 
  arr-stringify-request
;  h-id
 )

)


 
 (defn- lazy-input [input-stream]
  (let [step (fn step []
        (let [c (.read input-stream)]
          (when-not (== c -1)
            (cons (char c) (lazy-seq (step))))))]
   (lazy-seq (step))))
  
 (def arr-chars (arr lazy-input))
 
 
  (def arr-lines 
  ;  (>>> 
 (arr-accum-eager "" (fn [state input] (if (or (= input \newline) (= input \return)) state
           (str state input))) (fn [state input] (= input \newline)))
  ;   (arr-strict (fn [input] (if input input nil)))
     
  ;  )
 )
 
 
 (def arr-code-headers 
 
   (arr-accum
     [] (fn [[code headers] input] (if code [code (concat headers [input])] [input []])) (fn [state input] (= input "")))
 
 
 
 
 
 )
 
 (defn header-from-string [accum header]
  (if header 
    (let [
        [k v] (. header split ": ")]
   
   (assoc accum (keyword k) v)
    )
   accum
  )
 )
 
 (def arr-header-lines-to-header-map
  (arr-strict (fn [input] (reduce header-from-string {} input)))
 ) 
 (import [rojat.io FixedLengthInputStream] [net.matuschek.util ChunkedInputStream])
 (defn- extract-code-headers [sequence]
  (reduce (fn [accum elem] (if accum accum (if elem elem))) nil sequence)
 )
 (def arr-adapt-stream (arr (fn [sequence in]
  (let [[code headers] (extract-code-headers sequence)
        ;code (first code-headers)
        ;headers (second code-headers)
        te (:Transfer-Encoding headers)
        chunked (= te "chunked")
        contentLength (:Content-Length headers)
        s (if contentLength (FixedLengthInputStream. in (Integer/parseInt contentLength)))]
      [[code headers] (if chunked (ChunkedInputStream. in) s)]
 )))
 
 )
 
 
 (def arr-process-response
 
 (>>>
  (&&& arr-chars h-id) 
 ; h-id
  (h-first (app arr-lines))
   
 
  
  (h-first (app arr-code-headers))
   
  ; :: [[code [header1 header2]] stream]
 (h-first (app (arr-switch-non-nil (arr-switch-between 0 0 (h-second arr-header-lines-to-header-map) h-id))))
 ;  )
    
 ; :: [[code {:header1 header1 :header2 header2}] stream]
 
  arr-adapt-stream
 
 )
 
 )
