
;tangled from rojat-arrows.org - do not modify
(ns rojat-arrows.extra (:use rojat-arrows.hughes))

(ns rojat-arrows.extra)
(def arr-second-only (arr (fn [a b] b)))
(def arr-first-only (arr (fn [a b] a)))
(defmacro def-arr [name params body & [options]]
 (let [arr-fn# (if (= options :strict) 'arr-strict 'arr)]
 `(def ~name (~arr-fn# (fn ~params ~body)))
 )
)
(defn  arr-print [& [options]] (arr-strict (fn [input] (if (or input (= options :include-nils)) (print input)))))
(defn- reduce-to-non-nil [sequence]
 (reduce (fn [accum elem] (if elem elem (if accum accum))) nil sequence)
)
(def arr-reduce-to-non-nil
 (arr-strict reduce-to-non-nil)
)
(defn arr-delay-state [init]

(h-first (>>> (h-loop h-swap init) (arr (fn [this last] last))))
     

)

(defn arr-delay [init]
 (>>> (&&& h-id h-id) (arr-delay-state init) (arr (fn [f s] f)))
       

)
(defn arr-constantly [val]
 (arr (constantly val))
 
)
(defn- exchange! [atom val]
 (let [val1 @atom
       dummy (swap! atom (constantly val))]
      val1
 )
)
(defn arr-once [val]
(let [loaded (atom val)]
     (arr (fn [input] (if @loaded (exchange! loaded nil) nil)))
) 
)
(defn arr-assoc [kw val]
 (arr (fn [input] (assoc input kw val)))
)
(defn arr-dissoc [kw]
 (arr (fn [input] (dissoc input kw)))
)

(defn arr-tag [evt-mutating-arrow]
 (*** evt-mutating-arrow h-id)
)
(defn arr-route [pred af & more]
 
  
  (if (= pred :otherwise) af
  
  (>>> (arr (fn [a b] [(pred a) [a b]]))
       (||| af (if (empty? more)
                 h-id
               (apply arr-route more))))
  )
  
  
 
  
)
(defn arr-route-consume [pred af & more]
  (if (= pred :otherwise) af
  
  (>>> (h-first (arr pred))
       (||| af (if (empty? more)
                 h-id
               (apply arr-route-consume more))))
  )
  
)

(defn arr-edge [compare-fn]
  (>>>
   (&&&
    (arr-delay nil)
    h-id)
   ; :: [[ev1 last] [ev2 next]]
   (arr (fn [[ev1 last] [ev2 next]] [(if last (compare-fn last next) 0) ev2 next]))
   ; :: [comp ev2 next]
   (arr (fn [comp ev data] [(if (not (= 0 comp)) (assoc ev :edge (if (> 0 comp) :rising :falling)) ev) data]))
          )

  )

(defn arr-instantaneous-switch [pred af]

 (>>> (arr-strict (fn [input] [(pred input) input])) (||| af h-id))

)
(def arr-switch-non-nil
 (partial arr-instantaneous-switch identity)
)

(defn arr-switch [init state-fn pred-fn trueChannel falseChannel]
 (>>> (h-loop (arr state-fn) init) (arr-route-consume pred-fn trueChannel :otherwise falseChannel))
)



(defn arr-switch-between [lower upper trueChannel falseChannel]
  (arr-switch -1  (fn [state input] [(inc state) input]) (fn [state] (and (>= state lower) (<= state upper))) trueChannel falseChannel)
  )

(defn arr-toggle-switch [default-channel pred-on pred-off channel & more]
 (>>>
   (h-loop
    (arr (fn [state input] [(if (pred-off input) false (or state (pred-on input))) input]))
    false
    
   )
   (||| channel (if (empty? more) default-channel (apply (partial arr-toggle-switch default-channel) more)))
))

 
(defn- boolean-to-int [value]

  (if value 1 0)
  )


(defn arr-toggle-switch-inclusive [default-channel pred-on pred-off channel & more]
                          
                              (>>> (h-loop (arr (fn [state input] [(if (pred-off input) false (or state (pred-on input))) input])) false)
                                        
                                   (&&& (arr-constantly {}) h-id)
                                   (arr-edge (fn [lst nxt] (- (boolean-to-int (first lst)) (boolean-to-int (first nxt)))))
                                      
                                   (arr (fn [ev [state data]] [(or state (= (:edge ev) :falling)) data]))
                                   (||| channel (if (empty? more) default-channel (apply (partial arr-toggle-switch default-channel) more)))

                                      )

                              )

(def arr-sink (arr (fn [a & more] nil)))

(defn arr-accum
  

  [init accum-fn pred &[options]]
  (let [accum-input-nils (= options :accum-input-nils)]
   (>>> (h-loop (arr (fn [state input] 
         (let [
               tf (pred state input)]
           ;prepend the result of pred to the usual [state input]
           ;but do not accumulate if tf or the input is nil and not accumulating nils
           [tf [(if (or tf (and (nil? input) (not accum-input-nils))) state (accum-fn state input)) input]])))
         init
         ;this calculates the state from the exotic accumulator
         ;if the predicate is true, the state is reset to init
         (arr (fn [p [state input]] (if p init state)))
        )
       ; a true in the 1st pair will send to channel
       (||| h-id zero)
        (arr-strict (fn [[state input]] state)
     )
;       arr-reduce-to-non-nil
  )
)
)


(defn arr-accum-eager [init accum-fn pred & [options]]
 (let [accum-input-nils (= options :accum-input-nils)
      
       ]
 (>>> (h-loop (arr (fn [state input]
                    (let [
                        tf (if accum-input-nils 
                        (pred state input)
                        (if input (pred state input) true))]
                      ;accumulate if not nil input or accumulating input nils
                        [tf [(if (or input accum-input-nils) (accum-fn state input) state) input]])))
                      
         init
         (arr (fn [p [state input]] (if p init state)))
       )
       
        
       ; a true in the 1st pair will send to channel
       (||| h-id zero)
       (arr-strict (fn [[state input]] state))
;       arr-first-only
;       (app arr-reduce-to-non-nil)
  )
)
)
(ns rojat-arrows.extra)
(defn arr-accum-counting [init accum-fn n & options]
 
   (>>>
      (arr-accum [0 init] (fn [[count state] input] [(inc count) (accum-fn state input)])
                       (fn [[count state] input] (== count n)) options)
        (arr-strict (fn [[a b]] b))
    
    )    
        
                 
   
  
 
 
)


(def arr-drop (arr-strict (fn [[a]] a)))
(def arr-lift (arr-strict (fn [a] [[a]])))


(def arr-eval (arr (fn [f params] (apply f params))))
