
(ns rojat-arrows.core)


(defn arr [func]
  (fn [a] (if (coll? a) (apply func a) (func a)))
)


(defn >>> [af ag]

 (fn [a] (ag (af a)))

              
)

(defn first [af]
 (fn [[b d]] [(af b) d])
)

(defn second [af]
 (fn [[b d]] [b (af d)])
)



(defn *** [af ag]
 (>>> (first af) (second ag))
)
(defn &&& [af ag]
 (>>> (arr (fn [b] [b b])) (*** af ag))
)
