package rojat.math;

public class FixedPrecisionMath {

	public static double fix(double value, int precision) {
		
		double f = Math.pow(10, precision);
		double l = Math.rint(f * value);
		
		return l / f;
		
	}
	static int evenOdd(double d) {
		if (((Double) d).longValue() != d)
			return -1;
		if (Math.IEEEremainder(d, 2) == 0)
			return 1;
		return -1;
	}
	public static double cos(double angle, int precision) {
		double a = fix(angle, precision);
		double b = fix(2 * a / Math.PI, precision);
		if (Math.IEEEremainder(b, 4) == 0)
			return 1;
		
			if (Math.IEEEremainder(b, 2) == 0)
				return -1;
			if (Math.IEEEremainder(b + 1, 2) == 0)
				return 0;
		
		return fix(Math.cos(angle), precision);
		
		
	}
	public static double sin(double angle, int precision) {
		double a = fix(angle, precision);
		double b = fix(2 * a  / Math.PI, precision);
		if (Math.IEEEremainder(b, 2) == 0)
			return 0;
		if (Math.IEEEremainder(b + 1, 4) == 0)
			return -1;
		if (Math.IEEEremainder(b + 1, 2) == 0)
			return 1;
		return fix(Math.sin(angle), precision);
	}
	public static void main(String[] args) {
		double a =  Math.PI / 2 ;
		System.out.println(Math.cos(a));
		System.out.println(FixedPrecisionMath.cos(a, 10));
	}
	public static boolean equals(double a, double b, int precision) {
		return fix(a, precision) == fix(b, precision);
	}
}
