
;tangled from rojat-math.org  - do not modify
(ns rojat-math.core (:import [rojat.math FixedPrecisionMath Factorial BigSquareRoot]))

(defn cross [f s1 s2 & options]
 (map (fn [item] (map 
                   (if (some #{:self-interact} options) 
                     (partial f item)
                     (fn [a] (if (= a item) nil (f item a)))
                   )
                   s2))
        s1)
)

(defn dot [f s1 s2]
 (map (partial apply f) (map vector s1 s2))
)

(defn fix [value precision]
 (FixedPrecisionMath/fix value precision)
)
(defn cos ([value precision]
 (FixedPrecisionMath/cos value precision))
([value]
 (FixedPrecisionMath/cos value 5))
)
(defn sin ([value precision]
 (FixedPrecisionMath/sin value precision))
([value]
 (FixedPrecisionMath/sin value 5))
)

(defn f-= ([value1 value2 precision]
 (== (fix value1 precision) (fix value2 precision)))
([value1 value2]
 (f-= value1 value2 5)
))
 

(defn factorial [n]
 (. (Factorial/getInstance) getFactorial n)
)
(defn big-square-root [bigDecimal]
 (BigSquareRoot/getSquareRoot bigDecimal)
)
(defn c+ [v1 v2] 
  (dot + v1 v2))
(defn c- [v1 v2]
  (dot - v1 v2)
)



(defn to-spherical [x y z] (let [r (Math/sqrt (+ (* x x) (* y y) (* z z)))]
        [r (Math/atan2 y x) (Math/asin (/ z r))]
)
)


(defn from-spherical ([r theta phi]
 [(* r (Math/cos theta)) (* r (Math/sin theta)) (* r (Math/sin phi))])
( [precision r theta phi]
 [(* r (FixedPrecisionMath/cos theta precision)) (* r (FixedPrecisionMath/sin theta precision)) (* r (FixedPrecisionMath/sin phi precision))]
)
)
(defn inverse-spherical [r theta phi]
 [r (if (<= theta Math/PI) (+ theta Math/PI) (- theta Math/PI))
    (- Math/PI phi)]
)

(defn to-polar [x y]
 (let [r (Math/sqrt (+ (* x x) (* y y)))]
  [r (Math/atan2 x y)]
)

)
(defn from-polar ([r phi]
 [(* r (Math/sin phi)) (* r (Math/cos phi))])
 ([r phi precision]
 [(* r (FixedPrecisionMath/sin phi precision)) (* r (FixedPrecisionMath/cos phi precision))]
)



)
(defn pfn [func b1 b2]
 (apply to-polar (func (apply from-polar b1) (apply from-polar b2)))
)
(defn p+ [b1 b2]
 (pfn c+ b1 b2)
)
(defn p- [b1 b2]
 (pfn c- b1 b2)
)
