(ns common.db.pool
  "@ctdean"
  (:require
   [common.db.util :refer [format-jdbc-url]]
   [conf.core :as conf]
   [jdbc.pool.c3p0 :as c3p0]))

(def default-spec
  {:min-pool-size     3
   :max-pool-size     15
   :initial-pool-size 3
   })

(def datasource
  (c3p0/make-datasource-spec
   (merge default-spec
          {:connection-uri (format-jdbc-url (conf/get :database-url))}
          (conf/get :database-spec))))
