/*
 * Decompiled with CFR 0.152.
 */
package ru.petrsu.nest.son;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import ru.petrsu.nest.son.SonElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonBeanUtils {
    public static List<SonElement> findPath(SonElement sonElement, SonElement sonElement2) {
        LinkedList<SonElement> linkedList;
        SonElement sonElement32;
        ArrayList<SonElement> arrayList = new ArrayList<SonElement>();
        Object object = new ArrayList();
        HashSet<SonElement> hashSet = new HashSet<SonElement>();
        HashMap<SonElement, SonElement> hashMap = new HashMap<SonElement, SonElement>();
        arrayList.add(sonElement);
        hashSet.add(sonElement);
        block0: while (true) {
            for (SonElement sonElement32 : arrayList) {
                for (SonElement sonElement4 : SonBeanUtils.relatedElements(sonElement32)) {
                    if (hashSet.contains(sonElement4)) continue;
                    hashMap.put(sonElement4, sonElement32);
                    if (sonElement4 == sonElement2) break block0;
                    object.add(sonElement4);
                    hashSet.add(sonElement4);
                }
            }
            if (object.isEmpty()) {
                return null;
            }
            linkedList = arrayList;
            arrayList = object;
            object = linkedList;
            object.clear();
        }
        linkedList = new LinkedList<SonElement>();
        sonElement32 = sonElement2;
        while (true) {
            linkedList.add(0, sonElement32);
            if (sonElement32 == sonElement) break;
            sonElement32 = (SonElement)hashMap.get(sonElement32);
        }
        return linkedList;
    }

    public static Iterator<SonElement> relatedElementsIterator(final SonElement sonElement) {
        return new Iterator<SonElement>(){
            private BeanInfo beanInfo = null;
            private PropertyDescriptor[] pds = null;
            private int index = 0;
            private SonElement next = null;
            private Iterator pRelated = null;

            private void findNextElement() {
                if (this.beanInfo == null) {
                    try {
                        this.beanInfo = Introspector.getBeanInfo(sonElement.getClass());
                        this.pds = this.beanInfo.getPropertyDescriptors();
                    }
                    catch (IntrospectionException introspectionException) {
                        throw new RuntimeException(introspectionException);
                    }
                }
                while (!(this.index >= this.pds.length || this.pRelated != null && this.pRelated.hasNext())) {
                    this.nextProperty();
                }
                if (this.pRelated.hasNext()) {
                    this.next = (SonElement)this.pRelated.next();
                    return;
                }
            }

            private void nextProperty() {
                PropertyDescriptor propertyDescriptor;
                Method method;
                if ((method = (propertyDescriptor = this.pds[this.index++]).getReadMethod()) == null) {
                    return;
                }
                Class<?> clazz = propertyDescriptor.getPropertyType();
                try {
                    if (SonElement.class.isAssignableFrom(clazz)) {
                        SonElement sonElement2 = (SonElement)method.invoke((Object)sonElement, new Object[0]);
                        if (sonElement2 != null) {
                            this.pRelated = Collections.singleton(sonElement2).iterator();
                        }
                        return;
                    }
                    Class<?> clazz2 = SonBeanUtils.getElementType(clazz, method);
                    if (clazz2 != null && SonElement.class.isAssignableFrom(clazz2)) {
                        this.pRelated = Arrays.asList((Object[])method.invoke((Object)sonElement, new Object[0])).iterator();
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (IntrospectionException introspectionException) {
                    throw new RuntimeException(introspectionException);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.findNextElement();
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SonElement next() {
                if (this.next == null) {
                    this.findNextElement();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                try {
                    SonElement sonElement2 = this.next;
                    return sonElement2;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public static Iterable<SonElement> relatedElements(final SonElement sonElement) {
        return new Iterable<SonElement>(){

            @Override
            public Iterator<SonElement> iterator() {
                return SonBeanUtils.relatedElementsIterator(sonElement);
            }
        };
    }

    public static Class<?> getElementType(PropertyDescriptor propertyDescriptor) throws IntrospectionException {
        return SonBeanUtils.getElementType(propertyDescriptor.getPropertyType(), propertyDescriptor.getReadMethod());
    }

    public static Class<?> getElementType(Class<?> clazz, Method method) throws IntrospectionException {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (!Collection.class.isAssignableFrom(clazz)) {
            return null;
        }
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray.length < 1) {
            return null;
        }
        if (!(typeArray[0] instanceof Class)) {
            return null;
        }
        return (Class)typeArray[0];
    }

    static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BreadthFirstIterator
    implements Iterator<SonElement> {
        private Queue<SonElement> visitQueue = new ArrayDeque<SonElement>();
        private Deque<SonElement> expandQueue = new ArrayDeque<SonElement>();
        private Map<SonElement, Integer> visited = new HashMap<SonElement, Integer>();
        private final int maxDepth;
        private final boolean close;
        private boolean skipped = false;
        private SonElement expand = null;
        private int depth = 0;

        public BreadthFirstIterator(SonElement sonElement, int n, boolean bl) {
            this.visitQueue.add(sonElement);
            this.maxDepth = n;
            this.close = bl;
        }

        public BreadthFirstIterator(SonElement sonElement, int n) {
            this(sonElement, n, false);
        }

        public BreadthFirstIterator(SonElement sonElement) {
            this(sonElement, -1);
        }

        private void expand() {
            while (!this.expandQueue.isEmpty() && this.visitQueue.isEmpty()) {
                this.expand = this.expandQueue.remove();
                this.depth = this.visited.get(this.expand) + 1;
                if (this.maxDepth >= 0 && this.depth > this.maxDepth) continue;
                for (SonElement sonElement : SonBeanUtils.relatedElements(this.expand)) {
                    if (this.close) {
                        Integer n = this.visited.get(sonElement);
                        if (n != null && n == this.depth - 2) continue;
                        this.visitQueue.add(sonElement);
                        continue;
                    }
                    if (this.visited.containsKey(sonElement)) continue;
                    this.visitQueue.add(sonElement);
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.expand();
            return !this.visitQueue.isEmpty();
        }

        @Override
        public SonElement next() {
            this.expand();
            if (this.visitQueue.isEmpty()) {
                throw new NoSuchElementException();
            }
            SonElement sonElement = this.visitQueue.remove();
            if (this.visited.put(sonElement, this.depth) == null) {
                this.expandQueue.add(sonElement);
            }
            this.skipped = false;
            return sonElement;
        }

        public void skip() {
            if (this.skipped) {
                throw new IllegalStateException();
            }
            this.expandQueue.removeLast();
            this.skipped = true;
        }

        public SonElement getLastExpanded() {
            return this.expand;
        }

        public int getLevel() {
            return this.depth;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

