/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.User;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.ForeignKey;

@Entity
@Table(name="BILLING_DETAILS")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="BILLING_DETAILS_TYPE", discriminatorType=DiscriminatorType.STRING)
public abstract class BillingDetails
implements Serializable,
Comparable {
    @Id
    @GeneratedValue
    @Column(name="BILLING_DETAILS_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @Column(name="OWNER", nullable=false)
    private String owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID", updatable=false)
    @ForeignKey(name="FK_USER_ID")
    private User user;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();

    public BillingDetails() {
    }

    protected BillingDetails(String string, User user) {
        this.owner = string;
        this.user = user;
    }

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public User getUser() {
        return this.user;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BillingDetails)) {
            return false;
        }
        BillingDetails billingDetails = (BillingDetails)object;
        if (this.created.getTime() != billingDetails.created.getTime()) {
            return false;
        }
        return this.getOwner().equals(billingDetails.getOwner());
    }

    public int hashCode() {
        int n = this.getCreated().hashCode();
        n = 29 * n + this.getOwner().hashCode();
        return n;
    }

    public int compareTo(Object object) {
        if (object instanceof BillingDetails) {
            return Long.valueOf(this.getCreated().getTime()).compareTo(((BillingDetails)object).getCreated().getTime());
        }
        return 0;
    }

    public abstract boolean isValid();
}

