/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.User;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@GenericGenerator(name="userAddressSharedPKGenerator", strategy="foreign", parameters={@Parameter(name="property", value="user")})
@Entity
@Table(name="ADDRESS")
public class AddressEntity
implements Serializable {
    @Id
    @GeneratedValue(generator="userAddressSharedPKGenerator")
    @Column(name="ADDRESS_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @Column(name="STREET", length=255, nullable=false)
    private String street;
    @Column(name="ZIPCODE", length=16, nullable=false)
    private String zipcode;
    @Column(name="CITY", length=255, nullable=false)
    private String city;
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    @PrimaryKeyJoinColumn
    private User user;

    public AddressEntity() {
    }

    public AddressEntity(String string, String string2, String string3) {
        this.street = string;
        this.zipcode = string2;
        this.city = string3;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public int getVersion() {
        return this.version;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String string) {
        this.street = string;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String string) {
        this.zipcode = string;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String string) {
        this.city = string;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AddressEntity)) {
            return false;
        }
        AddressEntity addressEntity = (AddressEntity)object;
        if (!this.city.equals(addressEntity.city)) {
            return false;
        }
        if (!this.street.equals(addressEntity.street)) {
            return false;
        }
        return this.zipcode.equals(addressEntity.zipcode);
    }

    public int hashCode() {
        int n = this.street.hashCode();
        n = 29 * n + this.zipcode.hashCode();
        n = 29 * n + this.city.hashCode();
        return n;
    }

    public String toString() {
        return "Street: '" + this.getStreet() + "', " + "Zipcode: '" + this.getZipcode() + "', " + "City: '" + this.getCity() + "'";
    }
}

