/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.Address;
import auction.model.AddressEntity;
import auction.model.BillingDetails;
import auction.model.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="USERS")
@SecondaryTable(name="BILLING_ADDRESS", pkJoinColumns={@PrimaryKeyJoinColumn(name="USER_ID")})
@BatchSize(size=10)
public class User
implements Serializable,
Comparable {
    @Id
    @GeneratedValue
    @Column(name="USER_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @Column(name="FIRSTNAME", length=255, nullable=false)
    private String firstname;
    @Column(name="LASTNAME", length=255, nullable=false)
    private String lastname;
    @Column(name="USERNAME", length=16, nullable=false, unique=true)
    private String username;
    @Column(name="`PASSWORD`", length=12, nullable=false)
    private String password;
    @Column(name="EMAIL", length=255, nullable=false)
    private String email;
    @Column(name="RANK", nullable=false)
    private int ranking = 0;
    @Column(name="IS_ADMIN", nullable=false)
    private boolean admin = false;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="street", column=@Column(name="HOME_STREET", length=255)), @AttributeOverride(name="zipcode", column=@Column(name="HOME_ZIPCODE", length=16)), @AttributeOverride(name="city", column=@Column(name="HOME_CITY", length=255))})
    private Address homeAddress;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="street", column=@Column(name="STREET", length=255, table="BILLING_ADDRESS")), @AttributeOverride(name="zipcode", column=@Column(name="ZIPCODE", length=16, table="BILLING_ADDRESS")), @AttributeOverride(name="city", column=@Column(name="CITY", length=255, table="BILLING_ADDRESS"))})
    private Address billingAddress;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @PrimaryKeyJoinColumn
    private AddressEntity shippingAddress;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="user")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<BillingDetails> billingDetails = new HashSet<BillingDetails>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DEFAULT_BILLING_DETAILS_ID", nullable=true)
    @ForeignKey(name="FK_DEFAULT_BILLING_DETAILS_ID")
    private BillingDetails defaultBillingDetails;
    @OneToMany(mappedBy="seller")
    private Collection<Item> itemsForSale = new ArrayList<Item>();
    @OneToMany(mappedBy="buyer")
    private Set<Item> boughtItems = new HashSet<Item>();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();

    public User() {
    }

    public User(String string, String string2, String string3, String string4, String string5, int n, boolean bl, Address address, Address address2, AddressEntity addressEntity, Set<BillingDetails> set, BillingDetails billingDetails, Set<Item> set2, Set<Item> set3) {
        this.firstname = string;
        this.lastname = string2;
        this.username = string3;
        this.password = string4;
        this.email = string5;
        this.ranking = n;
        this.admin = bl;
        this.homeAddress = address;
        this.billingAddress = address2;
        this.shippingAddress = addressEntity;
        this.billingDetails = set;
        this.defaultBillingDetails = billingDetails;
        this.itemsForSale = set2;
        this.boughtItems = set3;
    }

    public User(String string, String string2, String string3, String string4, String string5) {
        this.firstname = string;
        this.lastname = string2;
        this.username = string3;
        this.password = string4;
        this.email = string5;
    }

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String string) {
        this.firstname = string;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String string) {
        this.lastname = string;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int n) {
        this.ranking = n;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public Address getHomeAddress() {
        return this.homeAddress;
    }

    public void setHomeAddress(Address address) {
        this.homeAddress = address;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address address) {
        this.billingAddress = address;
    }

    public AddressEntity getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(AddressEntity addressEntity) {
        this.shippingAddress = addressEntity;
    }

    public Set<BillingDetails> getBillingDetails() {
        return this.billingDetails;
    }

    public void addBillingDetails(BillingDetails billingDetails) {
        if (billingDetails == null) {
            throw new IllegalArgumentException("Can't add a null BillingDetails.");
        }
        this.getBillingDetails().add(billingDetails);
        if (this.getBillingDetails().size() == 1) {
            this.setDefaultBillingDetails(billingDetails);
        }
    }

    public void removeBillingDetails(BillingDetails billingDetails) throws Exception {
        if (billingDetails == null) {
            throw new IllegalArgumentException("Can't add a null BillingDetails.");
        }
        if (this.getBillingDetails().size() < 2) {
            throw new Exception("Please set new default BillingDetails first");
        }
        this.getBillingDetails().remove(billingDetails);
        this.setDefaultBillingDetails(this.getBillingDetails().iterator().next());
    }

    public BillingDetails getDefaultBillingDetails() {
        return this.defaultBillingDetails;
    }

    public void setDefaultBillingDetails(BillingDetails billingDetails) {
        this.defaultBillingDetails = billingDetails;
    }

    public Collection<Item> getItemsForSale() {
        return this.itemsForSale;
    }

    public void setItemsForSale(Collection<Item> collection) {
        this.itemsForSale = collection;
    }

    public Set<Item> getBoughtItems() {
        return this.boughtItems;
    }

    public void addBoughtItem(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Null Item!");
        }
        item.setBuyer(this);
        this.boughtItems.add(item);
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.getUsername().equals(user.getUsername());
    }

    public int hashCode() {
        return this.getUsername().hashCode();
    }

    public String toString() {
        return "User ('" + this.getId() + "'), " + "Username: '" + this.getUsername() + "'";
    }

    public int compareTo(Object object) {
        if (object instanceof User) {
            return Long.valueOf(this.getCreated().getTime()).compareTo(((User)object).getCreated().getTime());
        }
        return 0;
    }
}

