/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.Item;
import auction.model.MonetaryAmount;
import auction.model.User;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BID")
@org.hibernate.annotations.Entity(mutable=false)
public class Bid
implements Serializable,
Comparable {
    @Id
    @GeneratedValue
    @Column(name="BID_ID")
    private Long id = null;
    @Type(type="monetary_amount_usd")
    @Columns(columns={@Column(name="BID_AMOUNT", length=2, updatable=false), @Column(name="BID_AMOUNT_CURRENCY", length=3, updatable=false)})
    private MonetaryAmount amount;
    @ManyToOne
    @JoinColumn(name="ITEM_ID", nullable=false, updatable=false, insertable=false)
    @ForeignKey(name="FK_ITEM_ID")
    private Item item;
    @ManyToOne
    @JoinColumn(name="BIDDER_ID", nullable=false, updatable=false)
    @ForeignKey(name="FK_BIDDER_ID")
    private User bidder;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();
    @Transient
    private boolean successful = false;

    public Bid() {
    }

    public Bid(MonetaryAmount monetaryAmount, Item item, User user) {
        this.amount = monetaryAmount;
        this.item = item;
        this.bidder = user;
    }

    public Long getId() {
        return this.id;
    }

    public MonetaryAmount getAmount() {
        return this.amount;
    }

    public Item getItem() {
        return this.item;
    }

    public User getBidder() {
        return this.bidder;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean bl) {
        this.successful = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Bid)) {
            return false;
        }
        Bid bid = (Bid)object;
        if (!this.getItem().getId().equals(bid.getItem().getId())) {
            return false;
        }
        if (this.created.getTime() != bid.created.getTime()) {
            return false;
        }
        return this.amount.equals(bid.amount);
    }

    public int hashCode() {
        int n = this.amount.hashCode();
        n = 29 * n + this.created.hashCode();
        return n;
    }

    public String toString() {
        return "Bid ('" + this.getId() + "'), " + "Created: '" + this.getCreated() + "' " + "Amount: '" + this.getAmount() + "'";
    }

    public int compareTo(Object object) {
        if (object instanceof Bid) {
            return Long.valueOf(this.getCreated().getTime()).compareTo(((Bid)object).getCreated().getTime());
        }
        return 0;
    }
}

