/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.BillingDetails;
import auction.model.CreditCardType;
import auction.model.User;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;

@Entity
@DiscriminatorValue(value="CC")
@SecondaryTable(name="CREDIT_CARD", pkJoinColumns={@PrimaryKeyJoinColumn(name="CREDIT_CARD_ID")})
public class CreditCard
extends BillingDetails {
    @Enumerated(value=EnumType.STRING)
    @Column(table="CREDIT_CARD", name="CC_TYPE", nullable=false)
    private CreditCardType type;
    @Column(table="CREDIT_CARD", name="CC_NUMBER", nullable=false, updatable=false, length=16)
    private String number;
    @Column(table="CREDIT_CARD", name="CC_EXP_MONTH", nullable=false, updatable=false, length=2)
    private String expMonth;
    @Column(table="CREDIT_CARD", name="CC_EXP_YEAR", nullable=false, updatable=false, length=4)
    private String expYear;

    public CreditCard() {
    }

    public CreditCard(String string, User user, String string2, CreditCardType creditCardType, String string3, String string4) {
        super(string, user);
        this.type = creditCardType;
        this.number = string2;
        this.expMonth = string3;
        this.expYear = string4;
    }

    public CreditCardType getType() {
        return this.type;
    }

    public String getNumber() {
        return this.number;
    }

    public String getExpMonth() {
        return this.expMonth;
    }

    public String getExpYear() {
        return this.expYear;
    }

    public String toString() {
        return "CreditCard ('" + this.getId() + "'), " + "Type: '" + (Object)((Object)this.getType()) + "'";
    }

    public boolean isValid() {
        return this.getType().isValid(this);
    }
}

