/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.Auditable;
import auction.model.Bid;
import auction.model.CategorizedItem;
import auction.model.Category;
import auction.model.ItemState;
import auction.model.MonetaryAmount;
import auction.model.MonetaryAmountType;
import auction.model.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamedQueries(value={@NamedQuery(name="Item-getMinBid", query="select b from Bid b where b.amount.value = (select min(b.amount.value) from Bid b where b.item.id = :itemid)"), @NamedQuery(name="Item-getMaxBid", query="select b from Bid b where b.amount.value = (select max(b.amount.value) from Bid b where b.item.id = :itemid)"), @NamedQuery(name="findItemsByDescription", query="select i from Item i where i.description like :desc)", hints={@QueryHint(name="org.hibernate.comment", value="My Comment"), @QueryHint(name="org.hibernate.fetchSize", value="50"), @QueryHint(name="org.hibernate.flushMode", value="never"), @QueryHint(name="org.hibernate.readOnly", value="true"), @QueryHint(name="org.hibernate.timeout", value="60")})})
@TypeDefs(value={@TypeDef(name="monetary_amount_usd", typeClass=MonetaryAmountType.class, parameters={@Parameter(name="convertTo", value="USD")}), @TypeDef(name="monetary_amount_eur", typeClass=MonetaryAmountType.class, parameters={@Parameter(name="convertTo", value="EUR")})})
@Entity
@javax.persistence.Table(name="ITEM")
@Filter(name="limitItemsByUserRank", condition=":currentUserRank >= (select u.RANK from USER u where u.USER_ID = SELLER_ID)")
@Check(constraints="START_DATE < END_DATE")
@Table(appliesTo="ITEM", indexes={@Index(name="IDX_INITIAL_PRICE", columnNames={"INITIAL_PRICE", "INITIAL_PRICE_CURRENCY"})})
public class Item
implements Serializable,
Comparable,
Auditable {
    private static final String COLLECTION_ID_GENERATOR = "identity";
    @Id
    @GeneratedValue
    @Column(name="ITEM_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @Column(name="ITEM_NAME", length=255, nullable=false, updatable=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SELLER_ID", nullable=false, updatable=false)
    @ForeignKey(name="FK_SELLER_ID")
    private User seller;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="ITEM_BUYER", joinColumns={@JoinColumn(name="ITEM_ID")}, inverseJoinColumns={@JoinColumn(name="USER_ID")})
    @ForeignKey(name="FK_ITEM_BUYER_USER_ID", inverseName="FK_ITEM_BUYER_ITEM_ID")
    private User buyer;
    @Column(name="DESCRIPTION", length=4000, nullable=false)
    private String description;
    @Type(type="monetary_amount_usd")
    @Columns(columns={@Column(name="INITIAL_PRICE", nullable=false, length=2), @Column(name="INITIAL_PRICE_CURRENCY", nullable=false, length=3)})
    private MonetaryAmount initialPrice;
    @Type(type="monetary_amount_usd")
    @Columns(columns={@Column(name="RESERVE_PRICE", nullable=false, length=2), @Column(name="RESERVE_PRICE_CURRENCY", nullable=false, length=3)})
    private MonetaryAmount reservePrice;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="START_DATE", nullable=false, updatable=false)
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="END_DATE", nullable=false, updatable=false)
    @Index(name="IDX_END_DATE")
    private Date endDate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="ITEM_STATE", nullable=false)
    private ItemState state;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="APPROVED_BY_USER_ID", nullable=true)
    @ForeignKey(name="FK_APPROVED_BY_USER_ID")
    private User approvedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="APPROVAL_DATETIME", nullable=true)
    private Date approvalDatetime;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ITEM_ID", nullable=false)
    @IndexColumn(name="BID_POSITION")
    @BatchSize(size=10)
    private List<Bid> bids = new ArrayList<Bid>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SUCCESSFUL_BID_ID", nullable=true)
    @ForeignKey(name="FK_SUCCESSFUL_BID_ID")
    private Bid successfulBid;
    @MapKey(name="id")
    @OneToMany(mappedBy="item")
    private Map<Long, Bid> bidsByIdentifier = new HashMap<Long, Bid>();
    @ManyToMany(mappedBy="items")
    private Set<Category> categories = new HashSet<Category>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="item")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<CategorizedItem> categorizedItems = new HashSet<CategorizedItem>();
    @CollectionOfElements
    @CollectionId(columns={@Column(name="ITEM_IMAGE_ID")}, type=@Type(type="long"), generator="identity")
    @JoinTable(name="ITEM_IMAGES", joinColumns={@JoinColumn(name="ITEM_ID")})
    @Column(name="FILENAME")
    @ForeignKey(name="FK_ITEM_IMAGE_ITEM_ID")
    private Collection<String> images = new ArrayList<String>();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();

    public Item() {
    }

    public Item(String string, User user, User user2, String string2, MonetaryAmount monetaryAmount, MonetaryAmount monetaryAmount2, Date date, Date date2, ItemState itemState, User user3, Date date3, List<Bid> list, Bid bid, Map<Long, Bid> map, Set<Category> set, Set<CategorizedItem> set2, Collection<String> collection) {
        this.name = string;
        this.seller = user;
        this.buyer = user2;
        this.description = string2;
        this.initialPrice = monetaryAmount;
        this.reservePrice = monetaryAmount2;
        this.startDate = date;
        this.endDate = date2;
        this.state = itemState;
        this.approvedBy = user3;
        this.approvalDatetime = date3;
        this.bids = list;
        this.successfulBid = bid;
        this.bidsByIdentifier = map;
        this.categories = set;
        this.categorizedItems = set2;
        this.images = collection;
        user.getItemsForSale().add(this);
    }

    public Item(String string, String string2, User user, MonetaryAmount monetaryAmount, MonetaryAmount monetaryAmount2, Date date, Date date2) {
        this.name = string;
        this.seller = user;
        this.description = string2;
        this.initialPrice = monetaryAmount;
        this.reservePrice = monetaryAmount2;
        this.startDate = date;
        this.endDate = date2;
        this.state = ItemState.DRAFT;
        user.getItemsForSale().add(this);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public User getSeller() {
        return this.seller;
    }

    public User getBuyer() {
        return this.buyer;
    }

    public void setBuyer(User user) {
        this.buyer = user;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public MonetaryAmount getInitialPrice() {
        return this.initialPrice;
    }

    public MonetaryAmount getReservePrice() {
        return this.reservePrice;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public ItemState getState() {
        return this.state;
    }

    public User getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(User user) {
        this.approvedBy = user;
    }

    public Date getApprovalDatetime() {
        return this.approvalDatetime;
    }

    public void setApprovalDatetime(Date date) {
        this.approvalDatetime = date;
    }

    public List<Bid> getBids() {
        return this.bids;
    }

    public void addBid(Bid bid) {
        if (bid == null) {
            throw new IllegalArgumentException("Can't add a null Bid.");
        }
        this.getBids().add(bid);
    }

    public Bid getSuccessfulBid() {
        return this.successfulBid;
    }

    public void setSuccessfulBid(Bid bid) {
        if (bid != null) {
            for (Bid bid2 : this.getBids()) {
                bid2.setSuccessful(false);
            }
            bid.setSuccessful(true);
            this.successfulBid = bid;
        }
    }

    public Map<Long, Bid> getBidsByIdentifier() {
        return this.bidsByIdentifier;
    }

    public void setBidsByIdentifier(Map<Long, Bid> map) {
        this.bidsByIdentifier = map;
    }

    public Set<Category> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public Set<CategorizedItem> getCategorizedItems() {
        return this.categorizedItems;
    }

    public Collection<String> getImages() {
        return this.images;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Item)) {
            return false;
        }
        Item item = (Item)object;
        if (this.created.getTime() != item.created.getTime()) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(item.name) : item.name != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 29 * n + this.created.hashCode();
        return n;
    }

    public String toString() {
        return "Item ('" + this.getId() + "'), " + "Name: '" + this.getName() + "' " + "Initial Price: '" + this.getInitialPrice() + "'";
    }

    public int compareTo(Object object) {
        if (object instanceof Item) {
            return Long.valueOf(this.getCreated().getTime()).compareTo(((Item)object).getCreated().getTime());
        }
        return 0;
    }

    public Bid placeBid(User user, MonetaryAmount monetaryAmount, Bid bid, Bid bid2) throws Exception {
        if (this.initialPrice.compareTo(monetaryAmount) > 0) {
            throw new Exception("Bid lower than initial price");
        }
        if (this.reservePrice.compareTo(monetaryAmount) > 0) {
            throw new Exception("Bid lower than reserve price");
        }
        if (bid != null && bid.getAmount().compareTo(monetaryAmount) > 0) {
            throw new Exception("Bid too low");
        }
        if (!this.getState().equals((Object)ItemState.ACTIVE)) {
            throw new Exception("Auction is not active yet");
        }
        if (this.getEndDate().before(new Date())) {
            throw new Exception("Can't place new bid, auction already ended");
        }
        Bid bid3 = new Bid(monetaryAmount, this, user);
        this.addBid(bid3);
        return bid3;
    }

    public void setPendingForApproval() {
        this.state = ItemState.PENDING;
    }

    public void approve(User user) throws Exception {
        if (!user.isAdmin()) {
            throw new Exception("Not an administrator");
        }
        if (!this.state.equals((Object)ItemState.PENDING)) {
            throw new IllegalStateException("Item still in draft");
        }
        this.state = ItemState.ACTIVE;
        this.approvedBy = user;
        this.approvalDatetime = new Date();
    }
}

