/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;

public class MonetaryAmount
implements Serializable {
    private final BigDecimal value;
    private final Currency currency;

    public MonetaryAmount(BigDecimal bigDecimal, Currency currency) {
        this.value = bigDecimal;
        this.currency = currency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MonetaryAmount)) {
            return false;
        }
        MonetaryAmount monetaryAmount = (MonetaryAmount)object;
        if (!this.currency.equals(monetaryAmount.currency)) {
            return false;
        }
        return this.value.equals(monetaryAmount.value);
    }

    public int hashCode() {
        int n = this.value.hashCode();
        n = 29 * n + this.currency.hashCode();
        return n;
    }

    public String toString() {
        return "Value: '" + this.getValue() + "', " + "Currency: '" + this.getCurrency() + "'";
    }

    public int compareTo(Object object) {
        if (object instanceof MonetaryAmount) {
            return this.getValue().compareTo(((MonetaryAmount)object).getValue());
        }
        return 0;
    }

    public static MonetaryAmount fromString(String string, String string2) {
        return new MonetaryAmount(new BigDecimal(string), Currency.getInstance(string2));
    }

    public static MonetaryAmount convert(MonetaryAmount monetaryAmount, Currency currency) {
        return new MonetaryAmount(monetaryAmount.getValue(), currency);
    }
}

