/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.MonetaryAmount;
import auction.model.MonetaryAmountCompositeUserType;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Currency;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;

public class MonetaryAmountType
extends MonetaryAmountCompositeUserType
implements ParameterizedType {
    private Currency convertTo;

    public void setParameterValues(Properties properties) {
        this.convertTo = Currency.getInstance(properties.getProperty("convertTo"));
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        if (resultSet.wasNull()) {
            return null;
        }
        BigDecimal bigDecimal = resultSet.getBigDecimal(stringArray[0]);
        Currency currency = Currency.getInstance(resultSet.getString(stringArray[1]));
        return new MonetaryAmount(bigDecimal, currency);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, 2);
        } else {
            MonetaryAmount monetaryAmount = (MonetaryAmount)object;
            MonetaryAmount monetaryAmount2 = MonetaryAmount.convert(monetaryAmount, this.convertTo);
            preparedStatement.setBigDecimal(n, monetaryAmount2.getValue());
            preparedStatement.setString(n + 1, this.convertTo.getCurrencyCode());
        }
    }
}

