/*
 * Decompiled with CFR 0.152.
 */
package auction.model;

import auction.model.AddressEntity;
import auction.model.Item;
import auction.model.ShipmentState;
import auction.model.User;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;

@Entity
@Table(name="SHIPMENT")
@SecondaryTable(name="ITEM_SHIPMENT", pkJoinColumns={@PrimaryKeyJoinColumn(name="SHIPMENT_ID")})
public class Shipment {
    @Id
    @GeneratedValue
    @Column(name="SHIPMENT_ID")
    private Long id = null;
    @Version
    @Column(name="OBJ_VERSION")
    private int version = 0;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="DELIVERY_ADDRESS_ID", nullable=false, updatable=false)
    @Fetch(value=FetchMode.JOIN)
    @ForeignKey(name="FK_SHIPMENT_DELIVERY_ADDRESS_ID")
    private AddressEntity deliveryAddress;
    @ManyToOne
    @JoinColumn(table="ITEM_SHIPMENT", name="ITEM_ID")
    @ForeignKey(name="FK_ITEM_SHIPMENT_ITEM_ID", inverseName="FK_ITEM_SHIPMENT_SHIPMENT_ID")
    private Item auction;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="BUYER_ID", nullable=false, updatable=false)
    @Fetch(value=FetchMode.JOIN)
    @ForeignKey(name="FK_SHIPMENT_BUYER_ID")
    private User buyer;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="SELLER_ID", nullable=false, updatable=false)
    @Fetch(value=FetchMode.JOIN)
    @ForeignKey(name="FK_SHIPMENT_SELLER_ID")
    private User seller;
    @Column(name="INSPECTION_PERIOD_DAYS", nullable=false, updatable=false)
    private int inspectionPeriodDays;
    @Enumerated(value=EnumType.STRING)
    @Column(name="SHIPMENT_STATE", nullable=false)
    private ShipmentState state = ShipmentState.AGREED;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date created = new Date();

    public Shipment() {
    }

    public Shipment(AddressEntity addressEntity, User user, User user2, int n) {
        this.deliveryAddress = addressEntity;
        this.buyer = user;
        this.seller = user2;
        this.inspectionPeriodDays = n;
    }

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public AddressEntity getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public Item getAuction() {
        return this.auction;
    }

    public void setAuction(Item item) {
        this.auction = item;
    }

    public User getSeller() {
        return this.seller;
    }

    public User getBuyer() {
        return this.buyer;
    }

    public int getInspectionPeriodDays() {
        return this.inspectionPeriodDays;
    }

    public ShipmentState getState() {
        return this.state;
    }

    public void setState(ShipmentState shipmentState) {
        this.state = shipmentState;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Shipment)) {
            return false;
        }
        Shipment shipment = (Shipment)object;
        if (this.inspectionPeriodDays != shipment.inspectionPeriodDays) {
            return false;
        }
        if (!this.buyer.getId().equals(shipment.buyer.getId())) {
            return false;
        }
        if (!this.created.equals(shipment.created)) {
            return false;
        }
        return this.seller.getId().equals(shipment.seller.getId());
    }

    public int hashCode() {
        int n = this.seller.getId().hashCode();
        n = 29 * n + this.buyer.getId().hashCode();
        n = 29 * n + this.inspectionPeriodDays;
        n = 29 * n + this.created.hashCode();
        return n;
    }

    public String toString() {
        return "Shipment ('" + this.getId() + "'), " + "State: '" + (Object)((Object)this.getState()) + "'";
    }
}

