(ns varpole.core)

(defmacro import-vars [& vars]
  (let [ls (transient [])]
    (doseq [ovar vars]
      (let [[ovar nvar] (if (sequential? ovar)
                          ovar
                          [ovar (symbol (last (clojure.string/split (name ovar) #"/")))])]
        (conj! ls `(def ~nvar ~ovar) )
        (conj! ls `(.resetMeta (var ~nvar) (assoc (meta (var ~nvar)) :arglists (:arglists (meta (var ~ovar))))))))
    (concat '(let []) (persistent! ls))))

(defmacro import-vars-with-first [first-params & vars]
  (let [ls (transient [])]
    (doseq [ovar vars]
      (let [[ovar nvar] (if (sequential? ovar)
                          ovar
                          [ovar (symbol (last (clojure.string/split (name ovar) #"/")))])]
        (conj! ls `(def ~nvar #(apply ~ovar ~first-params %&)) )
        (conj! ls `(.resetMeta (var ~nvar) (assoc (meta (var ~nvar)) :arglists (map (comp vec rest) (:arglists (meta (var ~ovar)))))))))
    (concat '(let []) (persistent! ls))))
