/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.httpkit.BytesInputStream;
import org.httpkit.DynamicBytes;
import org.httpkit.HttpStatus;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.ProtocolException;
import org.httpkit.client.AbortException;
import org.httpkit.client.Handler;
import org.httpkit.client.IFilter;
import org.httpkit.client.IRespListener;
import org.httpkit.client.IResponseHandler;

public class RespListener
implements IRespListener {
    private final DynamicBytes body;
    private Map<String, String> headers = new TreeMap<String, String>();
    private HttpStatus status;
    private final IResponseHandler handler;
    private final IFilter filter;
    private final ExecutorService pool;

    private boolean isText() {
        if (this.status == HttpStatus.OK) {
            String type = this.headers.get("content-type");
            if (type != null) {
                return (type = type.toLowerCase()).contains("text") || type.contains("json");
            }
            return false;
        }
        return true;
    }

    private DynamicBytes unzipBody() throws IOException {
        int read;
        InflaterInputStream is;
        String encoding = this.headers.get("content-encoding");
        if (encoding == null || this.body.length() == 0) {
            return this.body;
        }
        encoding = encoding.toLowerCase();
        BytesInputStream bis = new BytesInputStream(this.body.get(), this.body.length());
        if ("gzip".equals(encoding) || "x-gzip".equals(encoding)) {
            is = new GZIPInputStream(bis);
        } else if ("deflate".equals(encoding) || "x-deflate".equals(encoding)) {
            is = new InflaterInputStream(bis, new Inflater(true));
        } else {
            return this.body;
        }
        DynamicBytes unzipped = new DynamicBytes(this.body.length() * 5);
        byte[] buffer = new byte[4096];
        while ((read = ((InputStream)is).read(buffer)) != -1) {
            unzipped.append(buffer, read);
        }
        ((InputStream)is).close();
        return unzipped;
    }

    public RespListener(IResponseHandler handler, IFilter filter, ExecutorService pool) {
        this.body = new DynamicBytes(16384);
        this.filter = filter;
        this.handler = handler;
        this.pool = pool;
    }

    @Override
    public void onBodyReceived(byte[] buf, int length) throws AbortException {
        this.body.append(buf, length);
        if (this.filter != null && !this.filter.accept(this.body)) {
            throw new AbortException("Rejected when reading body, length: " + this.body.length());
        }
    }

    @Override
    public void onCompleted() {
        if (this.status == null) {
            this.pool.submit(new Handler(this.handler, new ProtocolException("No status")));
            return;
        }
        try {
            DynamicBytes bytes = this.unzipBody();
            if (this.isText()) {
                Charset charset = HttpUtils.detectCharset(this.headers, bytes);
                String html = new String(bytes.get(), 0, bytes.length(), charset);
                this.pool.submit(new Handler(this.handler, this.status.getCode(), this.headers, html));
            } else {
                BytesInputStream is = new BytesInputStream(bytes.get(), bytes.length());
                this.pool.submit(new Handler(this.handler, this.status.getCode(), this.headers, is));
            }
        }
        catch (IOException e) {
            this.handler.onThrowable(e);
        }
    }

    @Override
    public void onThrowable(Throwable t) {
        this.pool.submit(new Handler(this.handler, t));
    }

    @Override
    public void onHeadersReceived(Map<String, String> headers) throws AbortException {
        this.headers = headers;
        if (this.filter != null && !this.filter.accept(headers)) {
            throw new AbortException("Rejected when header received");
        }
    }

    @Override
    public void onInitialLineReceived(HttpVersion version, HttpStatus status) throws AbortException {
        this.status = status;
    }
}

