/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.httpkit.DynamicBytes;
import org.httpkit.HttpStatus;
import org.httpkit.HttpUtils;
import org.httpkit.server.DateFormatter;
import org.httpkit.server.HttpRequest;

public class ClojureRing {
    public static final Keyword SERVER_PORT = Keyword.intern((String)"server-port");
    public static final Keyword SERVER_NAME = Keyword.intern((String)"server-name");
    public static final Keyword REMOTE_ADDR = Keyword.intern((String)"remote-addr");
    public static final Keyword URI = Keyword.intern((String)"uri");
    public static final Keyword QUERY_STRING = Keyword.intern((String)"query-string");
    public static final Keyword SCHEME = Keyword.intern((String)"scheme");
    public static final Keyword REQUEST_METHOD = Keyword.intern((String)"request-method");
    public static final Keyword HEADERS = Keyword.intern((String)"headers");
    public static final Keyword CONTENT_TYPE = Keyword.intern((String)"content-type");
    public static final Keyword CONTENT_LENGTH = Keyword.intern((String)"content-length");
    public static final Keyword CHARACTER_ENCODING = Keyword.intern((String)"character-encoding");
    public static final Keyword BODY = Keyword.intern((String)"body");
    public static final Keyword WEBSOCKET = Keyword.intern((String)"websocket?");
    public static final Keyword ASYC_CHANNEL = Keyword.intern((String)"async-channel");
    public static final Keyword HTTP = Keyword.intern((String)"http");
    public static final Keyword STATUS = Keyword.intern((String)"status");
    public static final String CL = "Content-Length";

    public static int getStatus(Map<Keyword, Object> resp) {
        int status = 200;
        Object s = resp.get(STATUS);
        if (s instanceof Long) {
            status = ((Long)s).intValue();
        } else if (s instanceof Integer) {
            status = (Integer)s;
        }
        return status;
    }

    public static Map<String, Object> getHeaders(Map resp, boolean addKeepalive) {
        TreeMap<String, Object> headers = (TreeMap<String, Object>)resp.get(HEADERS);
        headers = headers == null ? new TreeMap<String, Object>() : new TreeMap(headers);
        if (addKeepalive) {
            headers.put("Connection", "Keep-Alive");
        }
        return headers;
    }

    public static ByteBuffer[] encode(int status, Map<String, Object> headers, Object body) {
        ByteBuffer bodyBuffer;
        headers = HttpUtils.camelCase(headers);
        headers.put("Server", "http-kit");
        headers.put("Date", DateFormatter.getDate());
        try {
            bodyBuffer = HttpUtils.bodyBuffer(body);
            if (!"chunked".equals(headers.get("Transfer-Encoding"))) {
                if (bodyBuffer != null) {
                    headers.put(CL, Integer.toString(bodyBuffer.remaining()));
                } else {
                    headers.put(CL, "0");
                }
            }
        }
        catch (IOException e) {
            byte[] b = e.getMessage().getBytes(HttpUtils.ASCII);
            status = 500;
            headers.clear();
            headers.put(CL, Integer.toString(b.length));
            bodyBuffer = ByteBuffer.wrap(b);
        }
        DynamicBytes bytes = new DynamicBytes(196);
        byte[] bs = HttpStatus.valueOf(status).getInitialLineBytes();
        bytes.append(bs, bs.length);
        HttpUtils.encodeHeaders(bytes, headers);
        ByteBuffer headBuffer = ByteBuffer.wrap(bytes.get(), 0, bytes.length());
        return new ByteBuffer[]{headBuffer, bodyBuffer};
    }

    public static IPersistentMap buildRequestMap(HttpRequest req) {
        TreeMap<Keyword, Object> m = new TreeMap<Keyword, Object>();
        m.put(SERVER_PORT, req.serverPort);
        m.put(SERVER_NAME, req.serverName);
        m.put(REMOTE_ADDR, req.getRemoteAddr());
        m.put(URI, req.uri);
        m.put(QUERY_STRING, req.queryString);
        m.put(SCHEME, HTTP);
        m.put(ASYC_CHANNEL, req.asycChannel);
        m.put(WEBSOCKET, req.isWebSocket);
        m.put(REQUEST_METHOD, req.method.KEY);
        m.put(HEADERS, PersistentArrayMap.create(req.headers));
        m.put(CONTENT_TYPE, req.contentType);
        m.put(CONTENT_LENGTH, req.contentLength);
        m.put(CHARACTER_ENCODING, req.charset);
        m.put(BODY, req.getBody());
        return PersistentArrayMap.create(m);
    }
}

