/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IFn;
import java.util.Map;
import java.util.TreeMap;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.server.AsyncChannel;
import org.httpkit.server.ClojureRing;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.ResponseCallback;

class HttpHandler
implements Runnable {
    final HttpRequest req;
    final ResponseCallback cb;
    final IFn handler;

    public HttpHandler(HttpRequest req, ResponseCallback cb, IFn handler) {
        this.req = req;
        this.cb = cb;
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            Map resp = (Map)this.handler.invoke((Object)ClojureRing.buildRequestMap(this.req));
            if (resp == null) {
                this.cb.run(ClojureRing.encode(404, null, null));
            } else {
                Object body = resp.get(ClojureRing.BODY);
                if (!(body instanceof AsyncChannel)) {
                    boolean addKeepalive = this.req.version == HttpVersion.HTTP_1_0 && this.req.isKeepAlive;
                    this.cb.run(ClojureRing.encode(ClojureRing.getStatus(resp), ClojureRing.getHeaders(resp, addKeepalive), body));
                }
            }
        }
        catch (Throwable e) {
            this.cb.run(ClojureRing.encode(500, new TreeMap<String, Object>(), e.getMessage()));
            HttpUtils.printError((Object)((Object)this.req.method) + " " + this.req.uri, e);
        }
    }
}

