/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import java.io.IOException;
import java.io.Reader;

public class SimpleStreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public int ttype = Integer.MIN_VALUE;
    public int nval = Integer.MIN_VALUE;
    public String sval = "";
    private static final int WHITESPACE = -5;
    private static final int QUOTE = -6;
    private final StringBuffer buf_ = new StringBuffer();
    private int nextType_;
    private final Reader reader_;
    private final int[] charType_ = new int[256];
    private boolean pushedBack_ = false;
    private char inQuote_ = '\u0000';

    public String toString() {
        switch (this.ttype) {
            case -2: {
                return Integer.toString(this.nval);
            }
            case -3: 
            case 34: {
                return "\"" + this.sval + "\"";
            }
            case 39: {
                return "'" + this.sval + "'";
            }
            case -1: {
                return "(EOF)";
            }
        }
        return "'" + (char)this.ttype + "'";
    }

    public SimpleStreamTokenizer(Reader reader) throws IOException {
        this.reader_ = reader;
        for (int ch = 0; ch < this.charType_.length; ch = (int)((char)(ch + 1))) {
            this.charType_[ch] = 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || ch == 45 ? -3 : (48 <= ch && ch <= 57 ? -2 : (0 <= ch && ch <= 32 ? -5 : ch));
        }
        this.nextToken();
    }

    public void ordinaryChar(char ch) {
        this.charType_[ch] = ch;
    }

    public void wordChars(char from, char to) {
        for (char ch = from; ch <= to; ch = (char)(ch + '\u0001')) {
            this.charType_[ch] = -3;
        }
    }

    public int nextToken() throws IOException {
        boolean transition;
        if (this.pushedBack_) {
            this.pushedBack_ = false;
            return this.ttype;
        }
        this.ttype = this.nextType_;
        do {
            char c;
            int ch;
            boolean whitespace;
            transition = false;
            do {
                if ((ch = this.reader_.read()) == -1) {
                    if (this.inQuote_ != '\u0000') {
                        throw new IOException("Unterminated quote");
                    }
                    c = '\uffffffff';
                } else {
                    c = this.charType_[ch];
                }
                whitespace = this.inQuote_ == '\u0000' && c == '\ufffffffb';
                boolean bl = transition = transition || whitespace;
            } while (whitespace);
            if (c == '\'' || c == '\"') {
                if (this.inQuote_ == '\u0000') {
                    this.inQuote_ = c;
                } else if (this.inQuote_ == c) {
                    this.inQuote_ = '\u0000';
                }
            }
            if (this.inQuote_ != '\u0000') {
                c = this.inQuote_;
            }
            boolean bl = transition = transition || this.ttype >= -1 && this.ttype != 39 && this.ttype != 34 || this.ttype != c;
            if (transition) {
                switch (this.ttype) {
                    case -3: {
                        this.sval = this.buf_.toString();
                        this.buf_.setLength(0);
                        break;
                    }
                    case 34: 
                    case 39: {
                        this.sval = this.buf_.toString().substring(1, this.buf_.length() - 1);
                        this.buf_.setLength(0);
                        break;
                    }
                    case -2: {
                        this.nval = Integer.parseInt(this.buf_.toString());
                        this.buf_.setLength(0);
                        break;
                    }
                }
                if (c != '\ufffffffb') {
                    this.nextType_ = c == '\ufffffffa' ? ch : (int)c;
                }
            }
            switch (c) {
                case '\ufffffffd': 
                case '\ufffffffe': 
                case '\"': 
                case '\'': {
                    this.buf_.append((char)ch);
                    break;
                }
            }
        } while (!transition);
        return this.ttype;
    }

    public void pushBack() {
        this.pushedBack_ = true;
    }
}

