(ns boot.new.runner
  (:require [clojure.string :as string]
            [stencil.core :refer [render-string]]
            [boot.new.templates :refer [renderer name-to-path ->files]]
            [clojure.java.io :refer [resource file]]))

(defn replace-quots [t]
  (string/replace t #"&quot;" "\""))

(def render (renderer "runner" #(replace-quots (render-string %1 %2))))

(defn trim-empty-lines [s]
  (-> (string/replace s #"^\n*" "")
      (string/replace #"\n*$" "")))

(defn parse-comment-sections [content]
  (->> (string/split content #"(\n|^);;\*")
       rest
       (map (fn [s]
              (let [[_ name content] (re-find #"([^\n]*)\n([^$]*)" s)]
                [(keyword name) (trim-empty-lines content)])))
       (into {})))

(def sections (-> (resource "deps-reqs.edn") slurp
                  parse-comment-sections))

(defn runner
  "FIXME: write documentation"
  [name]
  (let [data (merge {:name name
                     :sanitized (name-to-path name)}
                    sections)]
    (println "Generating fresh 'boot new' runner project.")
    (->files data
             ["build.boot"                              (render "build.boot"          data)]
             ["boot.properties"                         (render "boot.properties"     data)]
             ["src/cljs/{{sanitized}}/core.cljs"        (render "core.cljs"           data)]
             ["src/clj/{{sanitized}}/start.clj"         (render "start.clj"           data)]
             ["src/clj/{{sanitized}}/server.clj"        (render "server.clj"          data)]
             ["src/clj/{{sanitized}}/styles.clj"        (render "styles.clj"          data)]
             ["resources/index.html"                    (render "index.html"          data)]
             ["resources/js/main.cljs.edn"              (render "main.cljs.edn"       data)]
             [".gitignore"                              (render "gitignore"           data)]
             ["resources/css/reset_meyer.css"           (render "reset_meyer.css"     data)]
             ["resources/css/defstyles.css"             (render "defstyles.css"       data)])))
