(def +version+ "0.1.0-SNAPSHOT")
(def +name+ '{{name}})

{{both}}

{{back}}

{{front}}

(defn mk-ns-symbol [xs & [x]]
  (symbol (str (clojure.string/join "." xs)
               (when x (str "/" x)))))

(set-env!
 :source-paths #{"src/clj" "src/cljs"} 
 :resource-paths #{"resources"}
 :dependencies (concat both back front))

{{require-both}}

{{require-back}}

{{require-front}}

(let [main-ns (mk-ns-symbol [+name+ 'start])]
  (task-options!
   pom    {:project     +name+
           :version     +version+
           :description ""
           :license     {"The MIT License (MIT)"
                         "http://opensource.org/licenses/mit-license.php"}}
   reload {:on-jsload   (mk-ns-symbol [+name+ 'core] 'main)}
   repl   {:eval '(set! *print-length* 20)}
   jar    {:main main-ns}
   aot    {:namespace #{main-ns}}))

(deftask dev []
  (comp
   (serve
    :handler    (mk-ns-symbol [+name+ 'server] 'handler)
    :reload     true
    :port       3000)
   (watch)
   (cljs-repl)
   (reload)
   (cljs :optimizations :none
         :source-map true)
   (garden :styles-var (mk-ns-symbol [+name+ 'styles] 'base)
           :output-to "css/styles.css")
   (target)))

(deftask build-server []
  (comp
   (aot)
   (pom)
   (uber)
   (jar)))

(deftask build-client []
  (comp
   (cljs :optimizations :advanced)
   (garden)))

(deftask build []
  (comp
   (build-client)
   (build-server)))


