(defproject rwilson/clj-env "0.1.0"
  :description "General purpose environment configuration library"
  :url "http://github.com/rwilson/clj-env/"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"
            :comments "Same as clojure!"}

  :aliases {"build" ^{:doc "Clean, compile all, test"}
            ["do" ["clean"] ["jar"] ["test"] ["doc"]]

            "build-install" ^{:doc "Clean, compile all, test, & install"}
            ["do" ["clean"] ["jar"] ["test"] ["doc"] ["install"]]}

  :dependencies [[org.clojure/clojure "1.6.0"]
                 [com.taoensso/timbre "4.0.1"]
                 [clj-lib "0.1.0"]]

  :plugins [[codox "0.8.12"]]

  ;; Codox
  :codox {:defaults {:doc "FIXME: write docs"}
          :output-dir "doc/api"
          :src-dir-uri "http://github.com/rwilson/clj-env/blob/master/"
          :src-linenum-anchor-prefix "L"}

  ;; Target path with %s included to avoid cross-profile contamination
  :target-path "target/%s"
  :compile-path "%s/classy-files"

  ;; disable :protect so clean can nuke the docs
  :clean-targets ^{:protect false} ["doc/api" :target-path :compile-path]

  ;; Define network vs non-network test selectors
  :test-selectors {:default (fn [m] (not (or (:integration m)
                                            (:regression m)
                                            (:network m))))
                   :network :network
                   :integration :integration
                   :regression :regression
                   :all (constantly true)}

  :profiles {:uberjar {:aot all}})
