/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liqp.nodes.LNode;
import liqp.nodes.LiquidWalker;
import liqp.parser.LiquidLexer;
import liqp.parser.LiquidParser;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;

public class Template {
    private final CommonTree root;

    private Template(String input) {
        LiquidLexer lexer = new LiquidLexer((CharStream)new ANTLRStringStream(input));
        LiquidParser parser = new LiquidParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        try {
            this.root = parser.parse().getTree();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("could not parse input: " + input, e);
        }
    }

    private Template(File file) throws IOException {
        try {
            LiquidLexer lexer = new LiquidLexer((CharStream)new ANTLRFileStream(file.getAbsolutePath()));
            LiquidParser parser = new LiquidParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            this.root = parser.parse().getTree();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("could not parse input from " + file, e);
        }
    }

    public CommonTree getAST() {
        return this.root;
    }

    public static Template parse(String input) {
        return new Template(input);
    }

    public static Template parse(File file) throws IOException {
        return new Template(file);
    }

    public String render(String jsonMap) {
        Map map;
        try {
            map = (Map)new ObjectMapper().readValue(jsonMap, HashMap.class);
        }
        catch (Exception e) {
            throw new RuntimeException("invalid json map: '" + jsonMap + "'", e);
        }
        return this.render(map);
    }

    public String render(Object ... context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < context.length - 1; ++i) {
            Object key = context[i];
            if (key.getClass() != String.class) {
                throw new RuntimeException("illegal key: " + String.valueOf(key) + " (" + key.getClass().getName() + "). Must be a String.");
            }
            Object value = context[i + 1];
            map.put((String)key, value);
        }
        return this.render(map);
    }

    public String render(Map<String, Object> context) {
        LiquidWalker walker = new LiquidWalker((TreeNodeStream)new CommonTreeNodeStream((Object)this.root));
        try {
            LNode node = walker.walk();
            Object rendered = node.render(context);
            return rendered == null ? "" : String.valueOf(rendered);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toStringAST() {
        StringBuilder builder = new StringBuilder();
        this.walk(this.root, builder);
        return builder.toString();
    }

    private void walk(CommonTree tree, StringBuilder builder) {
        ArrayList<CommonTree> firstStack = new ArrayList<CommonTree>();
        firstStack.add(tree);
        ArrayList childListStack = new ArrayList();
        childListStack.add(firstStack);
        while (!childListStack.isEmpty()) {
            List childStack = (List)childListStack.get(childListStack.size() - 1);
            if (childStack.isEmpty()) {
                childListStack.remove(childListStack.size() - 1);
                continue;
            }
            tree = (CommonTree)childStack.remove(0);
            String indent = "";
            for (int i = 0; i < childListStack.size() - 1; ++i) {
                indent = indent + (((List)childListStack.get(i)).size() > 0 ? "|  " : "   ");
            }
            String tokenName = LiquidParser.tokenNames[tree.getType()];
            String tokenText = tree.getText().replaceAll("\\s+", " ").trim();
            builder.append(indent).append(childStack.isEmpty() ? "'- " : "|- ").append(tokenName).append(!tokenName.equals(tokenText) ? "='" + tokenText + "'" : "").append("\n");
            if (tree.getChildCount() <= 0) continue;
            childListStack.add(new ArrayList(tree.getChildren()));
        }
    }
}

