/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import liqp.filters.Filter;

class Date
extends Filter {
    private static Locale locale = Locale.ENGLISH;
    private static Set<String> datePatterns = new HashSet<String>();
    private static final Map<Character, SimpleDateFormat> LIQUID_TO_JAVA_FORMAT = new HashMap<Character, SimpleDateFormat>();

    Date() {
    }

    @Override
    public Object apply(Object value, Object ... params) {
        try {
            Long seconds;
            if (super.asString(value).equals("now")) {
                seconds = System.currentTimeMillis() / 1000L;
            } else if (super.isNumber(value)) {
                seconds = super.asNumber(value).longValue();
            } else {
                seconds = this.trySeconds(super.asString(value));
                if (seconds == null) {
                    return value;
                }
            }
            java.util.Date date = new java.util.Date(seconds * 1000L);
            String format = super.asString(super.get(0, params));
            if (format == null || format.trim().isEmpty()) {
                return value;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < format.length(); ++i) {
                char ch = format.charAt(i);
                if (ch == '%') {
                    if (++i == format.length()) {
                        builder.append("%");
                        break;
                    }
                    char next = format.charAt(i);
                    SimpleDateFormat javaFormat = LIQUID_TO_JAVA_FORMAT.get(Character.valueOf(next));
                    if (javaFormat == null) {
                        builder.append("%").append(next);
                        continue;
                    }
                    builder.append(javaFormat.format(date));
                    continue;
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return value;
        }
    }

    private static void init() {
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('%'), new SimpleDateFormat("%", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('a'), new SimpleDateFormat("EEE", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('A'), new SimpleDateFormat("EEEE", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('b'), new SimpleDateFormat("MMM", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('h'), new SimpleDateFormat("MMM", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('B'), new SimpleDateFormat("MMMM", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('c'), new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('d'), new SimpleDateFormat("dd", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('H'), new SimpleDateFormat("HH", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('I'), new SimpleDateFormat("hh", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('j'), new SimpleDateFormat("DDD", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('m'), new SimpleDateFormat("MM", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('M'), new SimpleDateFormat("mm", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('p'), new SimpleDateFormat("a", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('S'), new SimpleDateFormat("ss", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('U'), new SimpleDateFormat("ww", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('W'), new SimpleDateFormat("ww", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('w'), new SimpleDateFormat("F", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('x'), new SimpleDateFormat("MM/dd/yy", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('X'), new SimpleDateFormat("HH:mm:ss", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('y'), new SimpleDateFormat("yy", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('Y'), new SimpleDateFormat("yyyy", locale));
        LIQUID_TO_JAVA_FORMAT.put(Character.valueOf('Z'), new SimpleDateFormat("z", locale));
    }

    public static void setLocale(Locale locale) {
        Date.locale = locale;
        Date.init();
    }

    public static void addDatePattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("date-pattern cannot be null");
        }
        datePatterns.add(pattern);
    }

    public static void removeDatePattern(String pattern) {
        datePatterns.remove(pattern);
    }

    private Long trySeconds(String str) {
        for (String pattern : datePatterns) {
            SimpleDateFormat parser = new SimpleDateFormat(pattern, locale);
            try {
                long milliseconds = parser.parse(str).getTime();
                return milliseconds / 1000L;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    static {
        Date.addDatePattern("yyyy-MM-dd HH:mm:ss");
        Date.addDatePattern("EEE MMM ddhh:mm:ss yyyy");
        Date.init();
    }
}

