/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liqp.nodes.LNode;
import liqp.tags.Tag;

public class BlockNode
implements LNode {
    private List<LNode> children = new ArrayList<LNode>();

    public void add(LNode node) {
        this.children.add(node);
    }

    public List<LNode> getChildren() {
        return new ArrayList<LNode>(this.children);
    }

    @Override
    public Object render(Map<String, Object> context) {
        StringBuilder builder = new StringBuilder();
        for (LNode node : this.children) {
            Object value = node.render(context);
            if (value == null) continue;
            if (value == Tag.Statement.BREAK || value == Tag.Statement.CONTINUE) {
                return value;
            }
            if (value.getClass().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])value) {
                    builder.append(String.valueOf(obj));
                }
                continue;
            }
            builder.append(String.valueOf(value));
        }
        return builder.toString();
    }
}

