/*
 * Decompiled with CFR 0.152.
 */
package com.saarthak.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.saarthak.client.CouchbaseClient;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchBaseHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(CouchBaseHealthCheck.class);
    private final CouchbaseClient couchbaseClient;

    protected HealthCheck.Result check() throws Exception {
        log.info("Running health check for couch base");
        JsonArray nodes = this.couchbaseClient.getNodes();
        Boolean isHealthy = true;
        ArrayList nodesList = new ArrayList();
        ArrayList healthyNodes = new ArrayList();
        ArrayList unHealthyNodes = new ArrayList();
        nodes.iterator().forEachRemaining(node -> {
            JsonObject obj = (JsonObject)node;
            boolean isNodeHealthy = "healthy".equals(obj.get("status"));
            nodesList.add(isNodeHealthy);
            if (isNodeHealthy) {
                healthyNodes.add(obj.getString("hostname"));
            } else {
                unHealthyNodes.add(obj.getString("hostname"));
            }
        });
        for (Boolean node2 : nodesList) {
            isHealthy = isHealthy != false && node2 != false;
        }
        return isHealthy != false ? HealthCheck.Result.healthy((String)("Connected to Couchbase cluster. Healthy Nodes : " + healthyNodes)) : HealthCheck.Result.unhealthy((String)("Not Connected to Couchbase cluster. Healthy Nodes: " + healthyNodes + ". Unhealthy Nodes: " + unHealthyNodes));
    }

    @ConstructorProperties(value={"couchbaseClient"})
    public CouchBaseHealthCheck(CouchbaseClient couchbaseClient) {
        this.couchbaseClient = couchbaseClient;
    }
}

