# lein-version-suffix

[![Clojars Project](http://clojars.org/pazustep/lein-version-suffix/latest-version.svg)](http://clojars.org/pazustep/lein-version-suffix)

A library and Leiningen plugin to add a version suffix to files. This is ideal
for static files in a web application that change between releases, like
stylesheets and scripts.

The version suffix is generated from the SHA1 digest of the file contents. If
a file doesn't change beteween releases the suffix is retained but any minute
change in the file will result in a new version suffix. This means that a
versioned file is effectively immutable and can be cached forever.


## Installation

You can install the plugin by adding `pazustep/lein-version-suffix` to your
`project.clj` file in the `:plugins` **and** `:dependencies` sections, like
this:

```clojure
(defproject my-project "1.2.3"
  :plugins [[pazustep/lein-version-suffix "0.1.3"]]
  :dependencies [[pazustep/lein-version-suffix "0.1.3"]])
```


## Configuration

All configuration goes under the `:version-suffix` key. The following example
shows all supported options:

```clojure
(defproject my-project "1.2.3"
  :plugins [[pazustep/lein-version-suffix "0.1.3"]]
  :dependencies [[pazustep/lein-version-suffix "0.1.3"]]
  :version-suffix {
    :root "src/main/webapp"
    :files [
      "/javascripts/gen/main-prod.js"
      "/stylesheets/main.css"]
    :gzip true
    :ignore-missing true
    :clean true
    :quiet true
    :output-to "src/main/resources"})
```

`:root` should be the local filesystem path that will be root of your web
server. This is also a prefix for `:files` entries.

`:files` should be a vector of files to be versioned. All these files must
be under `:root`, and should start with a slash. At the moment, no wilcards
or recursion are supported; you must list each file you need to version.

`:gzip` is optional. If true, versioned files will also get a gzipped version.

`:ignore-missing` is optional. If true, entries in the `:files` array that refer
to missing files will be ignored. The default if to fail with an error if
files are missing.

`:clean` is optional. If true, old versioned files will be removed creating the
new versioned file. Use this with cars; old versions are detected using a
regular expression as strict as it can be, but it could accidentally match a
non versioned file.

`:quiet` is optional. If true, messages about file operations are omitted. By
default, messages are printed for missing, deleted an renamed files.

`:output-to` is also optional, and should be the directory where the
`assets.edn` file will be written. If omitted, the plugin will use the first
`:resource-paths` entry, or the first `:source-paths` entry as a fallback.

This file is used to resolve original file paths to versioned paths, and in
fact, is simply a map from the former to the latter.


## Usage

Run the plugin with `lein version-suffix`. If your versioned files are
generated by another task like `cljsbuild` you can run `version-suffix`
after them with `lein do`:

```sh
$ lein do cljsbuild once, version-suffix
```

At runtime, you can use the `pazustep.version-suffix/versioned-file-path`
function to obtain the path to a versioned file, given the base path:

```clojure
(ns myapp.handler
  (:require [pazustep.version-suffix :refer [versioned-file-path]])

  (versioned-file-path "/stylesheets/main.css")
  ;=> "/stylesheets/main-xuzspnyoaito2afrnslcireiw5p4l7hp.css"

  (versioned-file-path "/file-not-versioned")
  ;=> "/file-not-versioned"
```

`versioned-file-path` reads `assets.edn` from the classpath and use it to
resolve paths. This is a simple map lookup, so the path must match exactly.
If the configuration file is missing or there is no matching versioned file,
the argument is returned unchanged.

There is a second arity for `versioned-file-path` that accepts the paths map
as the first option, instead of loading it from the classpath. This lets you
create any fancy reloading scheme or build the configuration map in any way
you want.

## License

Copyright © 2015 Marcus Brito

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
