(ns samirsa.sahayak
  (:require [clojure.pprint]))

(defmacro -$>
  [x & forms]
  (println "-$>")
  (clojure.pprint/pprint x)
  (loop [x x
         forms forms
         intermediate []]
    (if forms
      (let [form (first forms)
            threaded (if (seq? form)
                       (with-meta `(~(first form) ~@(next form) ~x) (meta form))
                       (list form x))]
        (recur
         threaded
         (next forms)
         (conj intermediate `(do
                               (clojure.pprint/pprint '~threaded)
                               (clojure.pprint/pprint ~threaded)
                               (println "-------")))))
      (list 'do
            `(doseq [i# ~intermediate] i#)
            x))))

(defn in?
  "true if coll contains elm"
  [coll elm]
  (boolean (some #(= elm %) coll)))

(defn fnCall
  [ns this & that]
  (cond
    (string? this) (apply (ns-resolve ns (symbol this)) that)
    (fn? this)     (apply this that)
    :else          (conj that this)))
