/**
* @author Drew Noakes http://drewnoakes.com
*/
define(["require", "exports"], function(require, exports) {
    /// <reference path="../lib/handlebars.d.ts" />
    /// <reference path="../lib/jquery.d.ts" />
    var DOMTemplate = (function () {
        function DOMTemplate(templateId) {
            this.templateId = templateId;
            var templateElement = document.getElementById(templateId);

            if (!templateElement) {
                console.error('No element found with id', templateId);
                return;
            }

            var templateText = templateElement.textContent;

            console.assert(!!templateText);

            this.template = Handlebars.compile(templateText);
        }
        DOMTemplate.prototype.create = function (data) {
            return $(this.template(data)).get(0);
        };
        return DOMTemplate;
    })();

    
    return DOMTemplate;
});
//# sourceMappingURL=DOMTemplate.js.map
