/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.hw.HWRenderer;
import com.sun.scenario.effect.impl.hw.Shader;
import java.awt.GraphicsConfiguration;
import java.awt.image.VolatileImage;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.java2d.pipe.hw.AccelGraphicsConfig;

public abstract class HWEffectPeer
extends EffectPeer {
    protected HWEffectPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    private static String getHwPrefix(GraphicsConfiguration gc) {
        String gcName = gc.getClass().getSimpleName();
        if (gcName.startsWith("WGL") || gcName.startsWith("GLX")) {
            return "com.sun.scenario.effect.impl.hw.ogl.OGL";
        }
        if (gcName.startsWith("D3D")) {
            return "com.sun.scenario.effect.impl.hw.d3d.D3D";
        }
        return null;
    }

    private static boolean isHwValid(final GraphicsConfiguration gc) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (gc instanceof AccelGraphicsConfig) {
                    AccelGraphicsConfig agc = (AccelGraphicsConfig)((Object)gc);
                    int caps = agc.getContextCapabilities().getCaps();
                    return (caps & 0x100) != 0;
                }
                return false;
            }
        });
    }

    public static HWRenderer createRenderer(GraphicsConfiguration gc) {
        String prefix = HWEffectPeer.getHwPrefix(gc);
        if (prefix == null) {
            return null;
        }
        if (!HWEffectPeer.isHwValid(gc)) {
            return null;
        }
        Class<?> klass = null;
        try {
            klass = Class.forName(prefix + "Renderer");
        }
        catch (ClassNotFoundException e) {
            System.err.println(prefix + "Renderer class not found");
            return null;
        }
        catch (Throwable t) {
            return null;
        }
        try {
            Constructor<?> ctor = klass.getConstructor(GraphicsConfiguration.class);
            return (HWRenderer)((Object)ctor.newInstance(gc));
        }
        catch (Exception e) {
            System.err.println("Error instantiating " + klass.getName() + ":");
            e.printStackTrace();
            return null;
        }
    }

    public final ImageData filter(final Effect effect, final ImageData ... inputs) {
        return AccessController.doPrivileged(new PrivilegedAction<ImageData>(){

            @Override
            public ImageData run() {
                return HWEffectPeer.this.filterImpl(effect, inputs);
            }
        });
    }

    abstract ImageData filterImpl(Effect var1, ImageData ... var2);

    protected abstract boolean isSamplerLinear(int var1);

    protected abstract Shader createShader();

    protected abstract void updateShader(Shader var1);

    protected final HWRenderer getRenderer() {
        return (HWRenderer)super.getRenderer();
    }

    protected VolatileImage getDestImageFromPool(int w, int h) {
        return (VolatileImage)this.getRenderer().getCompatibleImage(w, h);
    }

    public Effect.AccelType getAccelType() {
        if (((Object)((Object)this.getRenderer())).getClass().getSimpleName().startsWith("OGL")) {
            return Effect.AccelType.OPENGL;
        }
        return Effect.AccelType.DIRECT3D;
    }
}

