/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.PerspectiveTransform;
import com.sun.scenario.effect.impl.hw.HWOneSamplerPeer;
import com.sun.scenario.effect.impl.hw.Shader;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public class HWPerspectiveTransformPeer
extends HWOneSamplerPeer {
    public HWPerspectiveTransformPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    protected final PerspectiveTransform getEffect() {
        return (PerspectiveTransform)super.getEffect();
    }

    private float[][] getITX() {
        PerspectiveTransformState state = (PerspectiveTransformState)AccessHelper.getState((Effect)this.getEffect());
        return state.getITX();
    }

    private float[] getTx0() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scalex = (float)(ib.getWidth() / nb.getWidth());
        float[] itx0 = this.getITX()[0];
        return new float[]{itx0[0] * scalex, itx0[1] * scalex, itx0[2] * scalex};
    }

    private float[] getTx1() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scaley = (float)(ib.getHeight() / nb.getHeight());
        float[] itx1 = this.getITX()[1];
        return new float[]{itx1[0] * scaley, itx1[1] * scaley, itx1[2] * scaley};
    }

    private float[] getTx2() {
        return this.getITX()[2];
    }

    public float[] getSourceRegion(int i) {
        Rectangle2D ib = ((Effect)this.getEffect().getInputs().get(0)).getBounds();
        Rectangle2D fb = this.getEffect().getBounds();
        float txmin = (float)((fb.getMinX() - ib.getX()) / ib.getWidth());
        float tymin = (float)((fb.getMinY() - ib.getY()) / ib.getHeight());
        float txmax = (float)((fb.getMaxX() - ib.getX()) / ib.getWidth());
        float tymax = (float)((fb.getMaxY() - ib.getY()) / ib.getHeight());
        return new float[]{txmin, tymin, txmax, tymax};
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("baseImg", 0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("tx2", 2);
        params.put("tx1", 1);
        params.put("tx0", 0);
        return this.getRenderer().createShader("PerspectiveTransform", samplers, params);
    }

    @Override
    protected void updateShader(Shader shader) {
        if (shader.getClass().getSimpleName().startsWith("OGL")) {
            float yoff = this.getDestNativeBounds().height;
            shader.setConstant("pixCoordYOffset", yoff);
        }
        float[] tx2_tmp = this.getTx2();
        shader.setConstant("tx2", tx2_tmp[0], tx2_tmp[1], tx2_tmp[2]);
        float[] tx1_tmp = this.getTx1();
        shader.setConstant("tx1", tx1_tmp[0], tx1_tmp[1], tx1_tmp[2]);
        float[] tx0_tmp = this.getTx0();
        shader.setConstant("tx0", tx0_tmp[0], tx0_tmp[1], tx0_tmp[2]);
    }
}

