/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw;

import com.sun.scenario.effect.PhongLighting;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.hw.HWTwoSamplerPeer;
import com.sun.scenario.effect.impl.hw.Shader;
import com.sun.scenario.effect.light.SpotLight;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class HWPhongLighting_DISTANTPeer
extends HWTwoSamplerPeer {
    private FloatBuffer kvals;

    public HWPhongLighting_DISTANTPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    protected final PhongLighting getEffect() {
        return (PhongLighting)super.getEffect();
    }

    private float getSurfaceScale() {
        return this.getEffect().getSurfaceScale();
    }

    private float getDiffuseConstant() {
        return this.getEffect().getDiffuseConstant();
    }

    private float getSpecularConstant() {
        return this.getEffect().getSpecularConstant();
    }

    private float getSpecularExponent() {
        return this.getEffect().getSpecularExponent();
    }

    private float[] getLightPosition() {
        return this.getEffect().getLight().getNormalizedLightPosition();
    }

    private float[] getLightColor() {
        return this.getEffect().getLight().getColor().getComponents(null);
    }

    private float getLightSpecularExponent() {
        return ((SpotLight)this.getEffect().getLight()).getSpecularExponent();
    }

    private float[] getLightDirection() {
        return ((SpotLight)this.getEffect().getLight()).getNormalizedLightDirection();
    }

    private FloatBuffer getKvals() {
        Rectangle bumpImgBounds = this.getInputNativeBounds(0);
        float xoff = 1.0f / (float)bumpImgBounds.width;
        float yoff = 1.0f / (float)bumpImgBounds.height;
        float[] kx = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] ky = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer((int)36);
        }
        this.kvals.clear();
        int kidx = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                this.kvals.put((float)j * xoff);
                this.kvals.put((float)i * yoff);
                this.kvals.put(kx[kidx]);
                this.kvals.put(ky[kidx]);
                ++kidx;
            }
        }
        this.kvals.rewind();
        return this.kvals;
    }

    protected float[] getSourceRegion(int inputIndex) {
        switch (inputIndex) {
            case 0: {
                Rectangle bump = this.getInputBounds(0);
                Rectangle orig = this.getInputBounds(1);
                Rectangle nb = this.getInputNativeBounds(0);
                float xdiff = (float)(bump.width - orig.width) / 2.0f;
                float ydiff = (float)(bump.height - orig.height) / 2.0f;
                float x1 = (float)bump.x + xdiff;
                float y1 = (float)bump.y + ydiff;
                float x2 = (float)(bump.x + bump.width) - xdiff;
                float y2 = (float)(bump.y + bump.height) - ydiff;
                float tx1 = x1 / (float)nb.width;
                float ty1 = y1 / (float)nb.height;
                float tx2 = x2 / (float)nb.width;
                float ty2 = y2 / (float)nb.height;
                return new float[]{tx1, ty1, tx2, ty2};
            }
            case 1: {
                return super.getSourceRegion(inputIndex);
            }
        }
        throw new InternalError("Invalid input index");
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            default: 
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("bumpImg", 0);
        samplers.put("origImg", 1);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("diffuseConstant", 1);
        params.put("surfaceScale", 0);
        params.put("lightColor", 5);
        params.put("kvals", 6);
        params.put("lightPosition", 4);
        params.put("specularConstant", 2);
        params.put("specularExponent", 3);
        return this.getRenderer().createShader("PhongLighting_DISTANT", samplers, params);
    }

    @Override
    protected void updateShader(Shader shader) {
        if (shader.getClass().getSimpleName().startsWith("OGL")) {
            float yoff = this.getDestNativeBounds().height;
            shader.setConstant("pixCoordYOffset", yoff);
        }
        shader.setConstant("diffuseConstant", this.getDiffuseConstant());
        shader.setConstant("surfaceScale", this.getSurfaceScale());
        float[] lightColor_tmp = this.getLightColor();
        shader.setConstant("lightColor", lightColor_tmp[0], lightColor_tmp[1], lightColor_tmp[2]);
        shader.setConstants("kvals", this.getKvals(), 0, 9);
        float[] lightPosition_tmp = this.getLightPosition();
        shader.setConstant("lightPosition", lightPosition_tmp[0], lightPosition_tmp[1], lightPosition_tmp[2]);
        shader.setConstant("specularConstant", this.getSpecularConstant());
        shader.setConstant("specularExponent", this.getSpecularExponent());
    }
}

