/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.ogl;

import com.sun.scenario.effect.impl.hw.Shader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.gl2.GLUgl2;

public class OGLShader
implements Shader {
    private int id;

    public OGLShader(String fragmentCode, Map<String, Integer> samplers) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        this.id = OGLShader.createProgram(gl, null, fragmentCode);
        if (samplers != null) {
            this.enable();
            for (String key : samplers.keySet()) {
                this.setConstant(key, samplers.get(key));
            }
            this.disable();
        }
    }

    public static OGLShader create(InputStream in) {
        return OGLShader.create(in, null);
    }

    public static OGLShader create(InputStream in, Map<String, Integer> samplers) {
        return new OGLShader(OGLShader.readStream(in), samplers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readStream(InputStream in) {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(chars)) > -1) {
                sb.append(String.valueOf(chars, 0, numRead));
            }
        }
        catch (IOException e) {
            System.err.println("Error reading stream");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                System.err.println("Error closing reader");
            }
        }
        return sb.toString();
    }

    private static int createProgram(GL2 gl, String vertexShaderSource, String fragmentShaderSource) throws GLException {
        if (vertexShaderSource == null && fragmentShaderSource == null) {
            throw new GLException("Either vertexShaderSource or fragmentShaderSource must be specified");
        }
        int vertexShader = 0;
        int fragmentShader = 0;
        int[] success = new int[1];
        int[] infoLogLength = new int[1];
        if (vertexShaderSource != null && (vertexShader = OGLShader.compileShader(gl, vertexShaderSource, true)) == 0) {
            return 0;
        }
        if (fragmentShaderSource != null && (fragmentShader = OGLShader.compileShader(gl, fragmentShaderSource, false)) == 0) {
            if (vertexShader != 0) {
                gl.glDeleteObjectARB(vertexShader);
            }
            return 0;
        }
        int shaderProgram = gl.glCreateProgramObjectARB();
        if (vertexShader != 0) {
            gl.glAttachObjectARB(shaderProgram, vertexShader);
            gl.glDeleteObjectARB(vertexShader);
        }
        if (fragmentShader != 0) {
            gl.glAttachObjectARB(shaderProgram, fragmentShader);
            gl.glDeleteObjectARB(fragmentShader);
        }
        gl.glLinkProgramARB(shaderProgram);
        gl.glGetObjectParameterivARB(shaderProgram, 35714, success, 0);
        gl.glGetObjectParameterivARB(shaderProgram, 35716, infoLogLength, 0);
        if (infoLogLength[0] > 1) {
            int len = infoLogLength[0];
            byte[] infoLog = new byte[len];
            gl.glGetInfoLogARB(shaderProgram, len, null, 0, infoLog, 0);
            System.err.println("Linker message: " + new String(infoLog));
        }
        if (success[0] == 0) {
            gl.glDeleteObjectARB(shaderProgram);
            return 0;
        }
        return shaderProgram;
    }

    private static int compileShader(GL2 gl, String shaderSource, boolean vertex) throws GLException {
        int kind = vertex ? 35633 : 35632;
        int[] success = new int[1];
        int[] infoLogLength = new int[1];
        int shader = gl.glCreateShaderObjectARB(kind);
        gl.glShaderSourceARB(shader, 1, new String[]{shaderSource}, new int[]{-1}, 0);
        gl.glCompileShaderARB(shader);
        gl.glGetObjectParameterivARB(shader, 35713, success, 0);
        gl.glGetObjectParameterivARB(shader, 35716, infoLogLength, 0);
        if (infoLogLength[0] > 1) {
            int len = infoLogLength[0];
            byte[] infoLog = new byte[len];
            gl.glGetInfoLogARB(shader, len, null, 0, infoLog, 0);
            System.err.println(shaderSource);
            System.err.println((vertex ? "Vertex" : "Fragment") + " compile message: " + new String(infoLog));
        }
        if (success[0] == 0) {
            gl.glDeleteObjectARB(shader);
            return 0;
        }
        return shader;
    }

    public int getProgramObject() {
        return this.id;
    }

    public void enable() throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        gl.glUseProgramObjectARB(this.id);
    }

    public void disable() throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        gl.glUseProgramObjectARB(0);
    }

    public void dispose() throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        gl.glDeleteObjectARB(this.id);
        this.id = 0;
    }

    public void setConstant(String name, int i0) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform1iARB(loc, i0);
    }

    public void setConstant(String name, int i0, int i1) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform2iARB(loc, i0, i1);
    }

    public void setConstant(String name, int i0, int i1, int i2) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform3iARB(loc, i0, i1, i2);
    }

    public void setConstant(String name, int i0, int i1, int i2, int i3) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform4iARB(loc, i0, i1, i2, i3);
    }

    public void setConstant(String name, float f0) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform1fARB(loc, f0);
    }

    public void setConstant(String name, float f0, float f1) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform2fARB(loc, f0, f1);
    }

    public void setConstant(String name, float f0, float f1, float f2) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform3fARB(loc, f0, f1, f2);
    }

    public void setConstant(String name, float f0, float f1, float f2, float f3) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform4fARB(loc, f0, f1, f2, f3);
    }

    public void setConstants(String name, IntBuffer buf, int off, int count) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform4ivARB(loc, count, buf);
    }

    public void setConstants(String name, FloatBuffer buf, int off, int count) throws GLException {
        GL2 gl = GLUgl2.getCurrentGL2();
        int loc = gl.glGetUniformLocationARB(this.id, name);
        gl.glUniform4fvARB(loc, count, buf);
    }
}

