/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.InvertMask;
import com.sun.scenario.effect.Offset;
import com.sun.scenario.effect.Shadow;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.SourceContent;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class InnerShadow
extends Effect {
    private final InvertMask invert;
    private final Shadow shadow;
    private final Offset offset;
    private final Blend blend;

    public InnerShadow() {
        this(new Source(false), new Source(true));
    }

    public InnerShadow(Effect input) {
        this(input, input);
    }

    public InnerShadow(Effect shadowSourceInput, Effect contentInput) {
        this.invert = new InvertMask(10, shadowSourceInput);
        this.shadow = new Shadow(10.0f, Color.BLACK, (Effect)this.invert);
        this.offset = new Offset(0, 0, this.shadow);
        this.blend = new Blend(Blend.Mode.SRC_ATOP, contentInput, this.offset);
    }

    public final Effect getShadowSourceInput() {
        return this.shadow.getInput();
    }

    public void setShadowSourceInput(Effect shadowSourceInput) {
        this.shadow.setInput(shadowSourceInput);
    }

    public final Effect getContentInput() {
        return this.blend.getBottomInput();
    }

    public void setContentInput(Effect contentInput) {
        this.blend.setBottomInput(contentInput);
    }

    public float getRadius() {
        return this.shadow.getRadius();
    }

    public void setRadius(float radius) {
        float old = this.shadow.getRadius();
        this.invert.setPad((int)Math.ceil(radius));
        this.shadow.setRadius(radius);
        this.firePropertyChange("radius", Float.valueOf(old), Float.valueOf(radius));
    }

    public Color getColor() {
        return this.shadow.getColor();
    }

    public void setColor(Color color) {
        Color old = this.shadow.getColor();
        this.shadow.setColor(color);
        this.firePropertyChange("color", old, color);
    }

    public int getOffsetX() {
        return this.offset.getX();
    }

    public void setOffsetX(int xoff) {
        int old = this.offset.getX();
        this.offset.setX(xoff);
        this.firePropertyChange("offsetX", old, xoff);
    }

    public int getOffsetY() {
        return this.offset.getY();
    }

    public void setOffsetY(int yoff) {
        int old = this.offset.getY();
        this.offset.setY(yoff);
        this.firePropertyChange("offsetY", old, yoff);
    }

    @Override
    public void setSourceContent(SourceContent content) {
        super.setSourceContent(content);
        this.blend.setSourceContent(content);
    }

    @Override
    public int needsSourceContent() {
        return this.blend.needsSourceContent();
    }

    @Override
    public boolean isInDeviceSpace() {
        return this.blend.isInDeviceSpace();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.blend.getBounds();
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        return this.blend.filter(config);
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return this.shadow.getAccelType(config);
    }
}

