/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.SourceContent;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Merge
extends Effect {
    public Merge(Effect bottomInput, Effect topInput) {
        super(bottomInput, topInput);
    }

    public final Effect getBottomInput() {
        return this.getInputs().get(0);
    }

    public void setBottomInput(Effect bottomInput) {
        this.setInput(0, bottomInput);
    }

    public final Effect getTopInput() {
        return this.getInputs().get(1);
    }

    public void setTopInput(Effect topInput) {
        this.setInput(1, topInput);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D r = null;
        for (Effect input : this.getInputs()) {
            Rectangle2D effectBounds = input.getTransformedBounds();
            if (r == null) {
                r = new Rectangle2D.Float();
                r.setRect(effectBounds);
                continue;
            }
            r.add(effectBounds);
        }
        return r;
    }

    @Override
    public boolean isInDeviceSpace() {
        return true;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        SourceContent content = this.getSourceContent();
        Rectangle2D fullBounds = this.getBounds();
        Rectangle tmp = fullBounds.getBounds();
        Image dst = Merge.getCompatibleImage(config, tmp.width, tmp.height);
        Graphics2D gdst = (Graphics2D)dst.getGraphics();
        for (Effect input : this.getInputs()) {
            Rectangle2D origBounds = input.getBounds();
            AffineTransform oldXform = gdst.getTransform();
            if (!input.isInDeviceSpace()) {
                AffineTransform xform = content.getTransform();
                AffineTransform xform2 = new AffineTransform();
                xform2.translate(-fullBounds.getX(), -fullBounds.getY());
                xform2.concatenate(xform);
                xform2.translate(origBounds.getX(), origBounds.getY());
                gdst.setTransform(xform2);
                gdst.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else {
                gdst.translate(origBounds.getX() - fullBounds.getX(), origBounds.getY() - fullBounds.getY());
            }
            Image inputImg = input.filter(config);
            gdst.drawImage(inputImg, 0, 0, null);
            gdst.setTransform(oldXform);
            Merge.releaseCompatibleImage(config, inputImg);
        }
        gdst.dispose();
        return dst;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return Effect.AccelType.NONE;
    }
}

