/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.sw.SWRenderer;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class EffectPeer {
    public static final String rootPkg = "com.sun.scenario.effect";
    private static boolean trySIMD;
    private final GraphicsConfiguration config;
    private final Renderer renderer;
    private Effect effect;
    private int pass;
    private final Rectangle[] inputBounds = new Rectangle[2];
    private final Rectangle[] inputNativeBounds = new Rectangle[2];
    private final Rectangle destNativeBounds = new Rectangle();
    private static Map<GraphicsConfiguration, Map<String, EffectPeer>> peerCache;
    private static Map<GraphicsConfiguration, Renderer> rendererMap;

    protected EffectPeer(GraphicsConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("GraphicsConfig must be non-null");
        }
        this.config = config;
        this.renderer = EffectPeer.getRenderer(config);
    }

    public abstract ImageData filter(Effect var1, ImageData ... var2);

    public abstract Effect.AccelType getAccelType();

    protected final GraphicsConfiguration getGraphicsConfig() {
        return this.config;
    }

    protected Renderer getRenderer() {
        return this.renderer;
    }

    protected Effect getEffect() {
        return this.effect;
    }

    protected void setEffect(Effect effect) {
        this.effect = effect;
    }

    public final int getPass() {
        return this.pass;
    }

    public void setPass(int pass) {
        this.pass = pass;
    }

    protected final Rectangle getInputBounds(int inputIndex) {
        return this.inputBounds[inputIndex];
    }

    protected final void setInputBounds(int inputIndex, Rectangle r) {
        this.inputBounds[inputIndex] = r;
    }

    protected final Rectangle getInputNativeBounds(int inputIndex) {
        return this.inputNativeBounds[inputIndex];
    }

    protected final void setInputNativeBounds(int inputIndex, Rectangle r) {
        this.inputNativeBounds[inputIndex] = r;
    }

    protected float[] getSourceRegion(int inputIndex) {
        Rectangle b = this.getInputBounds(inputIndex);
        Rectangle nb = this.getInputNativeBounds(inputIndex);
        float x1 = b.x;
        float y1 = b.y;
        float x2 = x1 + (float)b.width;
        float y2 = y1 + (float)b.height;
        float tx1 = x1 / (float)nb.width;
        float ty1 = y1 / (float)nb.height;
        float tx2 = x2 / (float)nb.width;
        float ty2 = y2 / (float)nb.height;
        return new float[]{tx1, ty1, tx2, ty2};
    }

    protected final Rectangle getDestBounds() {
        Rectangle r = this.getEffect().getBounds().getBounds();
        r.setLocation(0, 0);
        return r;
    }

    protected final Rectangle getDestNativeBounds() {
        return this.destNativeBounds;
    }

    protected final void setDestNativeBounds(int w, int h) {
        this.destNativeBounds.setSize(w, h);
    }

    protected Object getSamplerData(int i) {
        return null;
    }

    protected boolean isOriginUpperLeft() {
        return this.getAccelType() != Effect.AccelType.OPENGL;
    }

    public static EffectPeer getInstance(GraphicsConfiguration gc, String name, int unrollCount) {
        String uname;
        EffectPeer peer;
        Map<String, EffectPeer> cache = peerCache.get(gc);
        if (cache == null) {
            cache = new HashMap<String, EffectPeer>();
            peerCache.put(gc, cache);
        }
        if ((peer = cache.get(name)) != null) {
            return peer;
        }
        if (unrollCount > 0) {
            uname = name + "_" + unrollCount;
            peer = cache.get(uname);
            if (peer != null) {
                return peer;
            }
        } else {
            uname = name;
        }
        Class<?> klass = null;
        String cacheName = null;
        if (EffectPeer.isHWEffectPeerAvailable(gc)) {
            try {
                cacheName = uname;
                klass = Class.forName("com.sun.scenario.effect.impl.hw.HW" + uname + "Peer");
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning: hardware peer not found for: " + uname);
            }
        }
        if (klass == null && trySIMD) {
            try {
                cacheName = name;
                klass = Class.forName("com.sun.scenario.effect.impl.sw.sse.SSE" + name + "Peer");
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
        }
        if (klass == null) {
            try {
                cacheName = name;
                klass = Class.forName("com.sun.scenario.effect.impl.sw.SW" + name + "Peer");
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalArgumentException("Software peer not found for: " + name);
            }
        }
        try {
            Constructor ctor = klass.getConstructor(GraphicsConfiguration.class);
            peer = (EffectPeer)ctor.newInstance(gc);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + klass.getName(), e);
        }
        cache.put(cacheName, peer);
        return peer;
    }

    private static boolean isRSLFriendly(Class klass) {
        if (klass.getName().equals("sun.java2d.pipe.hw.AccelGraphicsConfig")) {
            return true;
        }
        boolean rsl = false;
        for (Class<?> iface : klass.getInterfaces()) {
            if (!EffectPeer.isRSLFriendly(iface)) continue;
            rsl = true;
            break;
        }
        return rsl;
    }

    private static boolean isRSLAvailable(GraphicsConfiguration gc) {
        return EffectPeer.isRSLFriendly(gc.getClass());
    }

    private static boolean isHWEffectPeerAvailable(GraphicsConfiguration gc) {
        Renderer renderer = EffectPeer.getRenderer(gc);
        String klass = renderer.getClass().getSimpleName();
        return !klass.startsWith("SW") && !klass.startsWith("SSE");
    }

    private static Renderer createHWRenderer(GraphicsConfiguration gc) {
        Method m;
        Class<?> klass;
        try {
            klass = Class.forName("com.sun.scenario.effect.impl.hw.HWEffectPeer");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            m = klass.getMethod("createRenderer", GraphicsConfiguration.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (Renderer)m.invoke(null, gc);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Renderer getSSERenderer() {
        Method m;
        Class<?> klass;
        try {
            klass = Class.forName("com.sun.scenario.effect.impl.sw.sse.SSERenderer");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            m = klass.getMethod("getInstance", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (Renderer)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized Renderer getRenderer(GraphicsConfiguration gc) {
        if (gc == null) {
            throw new IllegalArgumentException("GraphicsConfig must be non-null");
        }
        Renderer r = rendererMap.get(gc);
        if (r == null) {
            if (EffectPeer.isRSLAvailable(gc)) {
                r = EffectPeer.createHWRenderer(gc);
            }
            if (r == null) {
                if (trySIMD) {
                    r = EffectPeer.getSSERenderer();
                }
                if (r == null) {
                    r = SWRenderer.getInstance();
                }
            }
            rendererMap.put(gc, r);
        }
        return r;
    }

    static {
        try {
            trySIMD = Boolean.getBoolean("com.sun.scenario.effect.simd");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        peerCache = new HashMap<GraphicsConfiguration, Map<String, EffectPeer>>();
        rendererMap = new HashMap<GraphicsConfiguration, Renderer>();
    }
}

