/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.scenario.effect.BoxBlur;

public class BoxBlurState {
    private float dx = -1.0f;
    private float dy = -1.0f;
    private int row = 0;
    private final BoxBlur effect;

    public BoxBlurState(BoxBlur effect) {
        this.effect = effect;
    }

    public int getRadius() {
        return this.effect.getRadius();
    }

    public void updateDeltas(float dx, float dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void invalidateDeltas() {
        this.dx = -1.0f;
        this.dy = -1.0f;
    }

    public float getDx() {
        return this.dx;
    }

    public float getDy() {
        return this.dy;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public float getRowOffset() {
        return (float)this.row * this.dy;
    }

    public float getColOffset() {
        float r = this.getRadius();
        return r * this.dx;
    }

    public int getRowCnt() {
        int r = this.getRadius();
        return r * 2 + 1;
    }

    public float getAlpha() {
        float r = this.getRadius();
        return 1.0f / ((2.0f * r + 1.0f) * (2.0f * r + 1.0f));
    }
}

