/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw;

import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.sw.SWEffectPeer;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class SWBlend_SRC_OUTPeer
extends SWEffectPeer {
    public SWBlend_SRC_OUTPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    @Override
    protected final Blend getEffect() {
        return (Blend)super.getEffect();
    }

    private float getOpacity() {
        return this.getEffect().getOpacity();
    }

    @Override
    protected float[] getSourceRegion(int inputIndex) {
        Rectangle src = this.getEffect().getInputs().get(inputIndex).getTransformedBounds().getBounds();
        Rectangle dst = this.getEffect().getBounds().getBounds();
        Rectangle nb = this.getInputNativeBounds(inputIndex);
        float sx1 = src.x;
        float sy1 = src.y;
        float sx2 = sx1 + (float)src.width;
        float sy2 = sy1 + (float)src.height;
        float dx1 = dst.x;
        float dy1 = dst.y;
        float dx2 = dx1 + (float)dst.width;
        float dy2 = dy1 + (float)dst.height;
        float tx1 = (dx1 - sx1) / (float)nb.width;
        float ty1 = (dy1 - sy1) / (float)nb.height;
        float tx2 = ((float)src.width + (dx2 - sx2)) / (float)nb.width;
        float ty2 = ((float)src.height + (dy2 - sy2)) / (float)nb.height;
        return new float[]{tx1, ty1, tx2, ty2};
    }

    @Override
    public ImageData filter(Effect effect, ImageData ... inputs) {
        this.setEffect(effect);
        BufferedImage src1 = (BufferedImage)inputs[1].getImage();
        int src1x = 0;
        int src1y = 0;
        int src1w = src1.getWidth();
        int src1h = src1.getHeight();
        int src1scan = src1.getWidth();
        int[] topImg = ((DataBufferInt)src1.getRaster().getDataBuffer()).getData();
        Rectangle src1Bounds = new Rectangle(src1x, src1y, src1w, src1h);
        this.setInputBounds(1, inputs[1].getBounds());
        this.setInputNativeBounds(1, src1Bounds);
        BufferedImage src0 = (BufferedImage)inputs[0].getImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getWidth();
        int src0h = src0.getHeight();
        int src0scan = src0.getWidth();
        int[] botImg = ((DataBufferInt)src0.getRaster().getDataBuffer()).getData();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        this.setInputBounds(0, inputs[0].getBounds());
        this.setInputNativeBounds(0, src0Bounds);
        float[] src1Rect = this.getSourceRegion(1);
        float[] src0Rect = this.getSourceRegion(0);
        Rectangle dstBounds = this.getDestBounds();
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        BufferedImage dst = this.getDestImageFromPool(dstw, dsth);
        this.setDestNativeBounds(dst.getWidth(), dst.getHeight());
        int dstscan = dst.getWidth();
        int[] dstPixels = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        float opacity = this.getOpacity();
        float inc1_x = (src1Rect[2] - src1Rect[0]) / (float)dstw;
        float inc1_y = (src1Rect[3] - src1Rect[1]) / (float)dsth;
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float pos1_y = src1Rect[1] + inc1_y * 0.5f;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos1_x = src1Rect[0] + inc1_x * 0.5f;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                int topImg_tmp;
                int botImg_tmp;
                float pixcoord_x = dx;
                float loc_tmp_x = pos0_x;
                float loc_tmp_y = pos0_y;
                if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x * (float)src0w);
                    int iloc_tmp_y = (int)(loc_tmp_y * (float)src0h);
                    boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                    botImg_tmp = out ? 0 : botImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                } else {
                    botImg_tmp = 0;
                }
                float sample_res_x = (float)(botImg_tmp >> 16 & 0xFF) / 255.0f;
                float sample_res_y = (float)(botImg_tmp >> 8 & 0xFF) / 255.0f;
                float sample_res_z = (float)(botImg_tmp & 0xFF) / 255.0f;
                float sample_res_w = (float)(botImg_tmp >>> 24) / 255.0f;
                float bot_x = sample_res_x;
                float bot_y = sample_res_y;
                float bot_z = sample_res_z;
                float bot_w = sample_res_w;
                float loc_tmp_x2 = pos1_x;
                float loc_tmp_y2 = pos1_y;
                if (loc_tmp_x2 >= 0.0f && loc_tmp_y2 >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x2 * (float)src1w);
                    int iloc_tmp_y = (int)(loc_tmp_y2 * (float)src1h);
                    boolean out = iloc_tmp_x >= src1w || iloc_tmp_y >= src1h;
                    topImg_tmp = out ? 0 : topImg[iloc_tmp_y * src1scan + iloc_tmp_x];
                } else {
                    topImg_tmp = 0;
                }
                sample_res_x = (float)(topImg_tmp >> 16 & 0xFF) / 255.0f;
                sample_res_y = (float)(topImg_tmp >> 8 & 0xFF) / 255.0f;
                sample_res_z = (float)(topImg_tmp & 0xFF) / 255.0f;
                sample_res_w = (float)(topImg_tmp >>> 24) / 255.0f;
                float top_x = sample_res_x * opacity;
                float top_y = sample_res_y * opacity;
                float top_z = sample_res_z * opacity;
                float top_w = sample_res_w * opacity;
                float bot_tmp_x = bot_x;
                float bot_tmp_y = bot_y;
                float bot_tmp_z = bot_z;
                float bot_tmp_w = bot_w;
                float top_tmp_x = top_x;
                float top_tmp_y = top_y;
                float top_tmp_z = top_z;
                float top_tmp_w = top_w;
                float blend_src_out_res_x = top_tmp_x * (1.0f - bot_tmp_w);
                float blend_src_out_res_y = top_tmp_y * (1.0f - bot_tmp_w);
                float blend_src_out_res_z = top_tmp_z * (1.0f - bot_tmp_w);
                float blend_src_out_res_w = top_tmp_w * (1.0f - bot_tmp_w);
                float color_x = blend_src_out_res_x;
                float color_y = blend_src_out_res_y;
                float color_z = blend_src_out_res_z;
                float color_w = blend_src_out_res_w;
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > 1.0f) {
                    color_x = 1.0f;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > 1.0f) {
                    color_y = 1.0f;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > 1.0f) {
                    color_z = 1.0f;
                }
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f + 0.5f) << 24;
                pos1_x += inc1_x;
                pos0_x += inc0_x;
            }
            pos1_y += inc1_y;
            pos0_y += inc0_y;
        }
        return new ImageData(dst, dstBounds);
    }
}

