/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw;

import com.sun.scenario.effect.Brightpass;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.sw.SWEffectPeer;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class SWBrightpassPeer
extends SWEffectPeer {
    public SWBrightpassPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    @Override
    protected final Brightpass getEffect() {
        return (Brightpass)super.getEffect();
    }

    private float getThreshold() {
        return this.getEffect().getThreshold();
    }

    @Override
    public ImageData filter(Effect effect, ImageData ... inputs) {
        this.setEffect(effect);
        BufferedImage src0 = (BufferedImage)inputs[0].getImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getWidth();
        int src0h = src0.getHeight();
        int src0scan = src0.getWidth();
        int[] baseImg = ((DataBufferInt)src0.getRaster().getDataBuffer()).getData();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        this.setInputBounds(0, inputs[0].getBounds());
        this.setInputNativeBounds(0, src0Bounds);
        float[] src0Rect = this.getSourceRegion(0);
        Rectangle dstBounds = this.getDestBounds();
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        BufferedImage dst = this.getDestImageFromPool(dstw, dsth);
        this.setDestNativeBounds(dst.getWidth(), dst.getHeight());
        int dstscan = dst.getWidth();
        int[] dstPixels = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        float threshold = this.getThreshold();
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float max_res;
                float dot_res;
                int baseImg_tmp;
                float pixcoord_x = dx;
                float luminanceVector_x = 0.2125f;
                float luminanceVector_y = 0.7154f;
                float luminanceVector_z = 0.0721f;
                float loc_tmp_x = pos0_x;
                float loc_tmp_y = pos0_y;
                if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x * (float)src0w);
                    int iloc_tmp_y = (int)(loc_tmp_y * (float)src0h);
                    boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                    baseImg_tmp = out ? 0 : baseImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                } else {
                    baseImg_tmp = 0;
                }
                float sample_res_x = (float)(baseImg_tmp >> 16 & 0xFF) / 255.0f;
                float sample_res_y = (float)(baseImg_tmp >> 8 & 0xFF) / 255.0f;
                float sample_res_z = (float)(baseImg_tmp & 0xFF) / 255.0f;
                float val_x = sample_res_x;
                float val_y = sample_res_y;
                float val_z = sample_res_z;
                float x_tmp_x = luminanceVector_x;
                float x_tmp_y = luminanceVector_y;
                float x_tmp_z = luminanceVector_z;
                float y_tmp_x = val_x;
                float y_tmp_y = val_y;
                float y_tmp_z = val_z;
                float luminance = dot_res = x_tmp_x * y_tmp_x + x_tmp_y * y_tmp_y + x_tmp_z * y_tmp_z;
                float x_tmp = 0.0f;
                float y_tmp = luminance - threshold;
                float x_tmp2 = luminance = (max_res = x_tmp > y_tmp ? x_tmp : y_tmp);
                float sign_res = Math.signum(x_tmp2);
                float color_x = val_x * sign_res;
                float color_y = val_y * sign_res;
                float color_z = val_z * sign_res;
                float color_w = 1.0f;
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > 1.0f) {
                    color_x = 1.0f;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > 1.0f) {
                    color_y = 1.0f;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > 1.0f) {
                    color_z = 1.0f;
                }
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f + 0.5f) << 24;
                pos0_x += inc0_x;
            }
            pos0_y += inc0_y;
        }
        return new ImageData(dst, dstBounds);
    }
}

