/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.PerspectiveTransform;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import com.sun.scenario.effect.impl.sw.SWEffectPeer;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class SWPerspectiveTransformPeer
extends SWEffectPeer {
    public SWPerspectiveTransformPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    @Override
    protected final PerspectiveTransform getEffect() {
        return (PerspectiveTransform)super.getEffect();
    }

    private float[][] getITX() {
        PerspectiveTransformState state = (PerspectiveTransformState)AccessHelper.getState(this.getEffect());
        return state.getITX();
    }

    private float[] getTx0() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scalex = (float)(ib.getWidth() / nb.getWidth());
        float[] itx0 = this.getITX()[0];
        return new float[]{itx0[0] * scalex, itx0[1] * scalex, itx0[2] * scalex};
    }

    private float[] getTx1() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scaley = (float)(ib.getHeight() / nb.getHeight());
        float[] itx1 = this.getITX()[1];
        return new float[]{itx1[0] * scaley, itx1[1] * scaley, itx1[2] * scaley};
    }

    private float[] getTx2() {
        return this.getITX()[2];
    }

    @Override
    public float[] getSourceRegion(int i) {
        Rectangle2D ib = this.getEffect().getInputs().get(0).getBounds();
        Rectangle2D fb = this.getEffect().getBounds();
        float txmin = (float)((fb.getMinX() - ib.getX()) / ib.getWidth());
        float tymin = (float)((fb.getMinY() - ib.getY()) / ib.getHeight());
        float txmax = (float)((fb.getMaxX() - ib.getX()) / ib.getWidth());
        float tymax = (float)((fb.getMaxY() - ib.getY()) / ib.getHeight());
        return new float[]{txmin, tymin, txmax, tymax};
    }

    @Override
    public ImageData filter(Effect effect, ImageData ... inputs) {
        this.setEffect(effect);
        BufferedImage src0 = (BufferedImage)inputs[0].getImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getWidth();
        int src0h = src0.getHeight();
        int src0scan = src0.getWidth();
        int[] baseImg = ((DataBufferInt)src0.getRaster().getDataBuffer()).getData();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        this.setInputBounds(0, inputs[0].getBounds());
        this.setInputNativeBounds(0, src0Bounds);
        float[] baseImg_vals = new float[4];
        float[] src0Rect = this.getSourceRegion(0);
        Rectangle dstBounds = this.getDestBounds();
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        BufferedImage dst = this.getDestImageFromPool(dstw, dsth);
        this.setDestNativeBounds(dst.getWidth(), dst.getHeight());
        int dstscan = dst.getWidth();
        int[] dstPixels = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        float[] tx2_arr = this.getTx2();
        float tx2_x = tx2_arr[0];
        float tx2_y = tx2_arr[1];
        float tx2_z = tx2_arr[2];
        float[] tx1_arr = this.getTx1();
        float tx1_x = tx1_arr[0];
        float tx1_y = tx1_arr[1];
        float tx1_z = tx1_arr[2];
        float[] tx0_arr = this.getTx0();
        float tx0_x = tx0_arr[0];
        float tx0_y = tx0_arr[1];
        float tx0_z = tx0_arr[2];
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float dot_res;
                float pixcoord_x = dx;
                float p1_x = pos0_x;
                float p1_y = pos0_y;
                float p1_z = 1.0f;
                float x_tmp_x = p1_x;
                float x_tmp_y = p1_y;
                float x_tmp_z = p1_z;
                float y_tmp_x = tx2_x;
                float y_tmp_y = tx2_y;
                float y_tmp_z = tx2_z;
                float p2_z = dot_res = x_tmp_x * y_tmp_x + x_tmp_y * y_tmp_y + x_tmp_z * y_tmp_z;
                x_tmp_x = p1_x;
                x_tmp_y = p1_y;
                x_tmp_z = p1_z;
                y_tmp_x = tx0_x;
                y_tmp_y = tx0_y;
                y_tmp_z = tx0_z;
                dot_res = x_tmp_x * y_tmp_x + x_tmp_y * y_tmp_y + x_tmp_z * y_tmp_z;
                float p2_x = dot_res / p2_z;
                x_tmp_x = p1_x;
                x_tmp_y = p1_y;
                x_tmp_z = p1_z;
                y_tmp_x = tx1_x;
                y_tmp_y = tx1_y;
                y_tmp_z = tx1_z;
                dot_res = x_tmp_x * y_tmp_x + x_tmp_y * y_tmp_y + x_tmp_z * y_tmp_z;
                float p2_y = dot_res / p2_z;
                float loc_tmp_x = p2_x;
                float loc_tmp_y = p2_y;
                this.lsample(baseImg, loc_tmp_x, loc_tmp_y, src0w, src0h, src0scan, baseImg_vals);
                float sample_res_x = baseImg_vals[0];
                float sample_res_y = baseImg_vals[1];
                float sample_res_z = baseImg_vals[2];
                float sample_res_w = baseImg_vals[3];
                float color_x = sample_res_x;
                float color_y = sample_res_y;
                float color_z = sample_res_z;
                float color_w = sample_res_w;
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > 1.0f) {
                    color_x = 1.0f;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > 1.0f) {
                    color_y = 1.0f;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > 1.0f) {
                    color_z = 1.0f;
                }
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f + 0.5f) << 24;
                pos0_x += inc0_x;
            }
            pos0_y += inc0_y;
        }
        return new ImageData(dst, dstBounds);
    }
}

