/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.ZoomRadialBlur;
import com.sun.scenario.effect.impl.ImageData;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.ZoomRadialBlurState;
import com.sun.scenario.effect.impl.sw.SWEffectPeer;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class SWZoomRadialBlurPeer
extends SWEffectPeer {
    private float[] centerTmp = new float[2];
    private float[] deltaTmp = new float[2];

    public SWZoomRadialBlurPeer(GraphicsConfiguration gc) {
        super(gc);
    }

    @Override
    protected final ZoomRadialBlur getEffect() {
        return (ZoomRadialBlur)super.getEffect();
    }

    private ZoomRadialBlurState getState() {
        return (ZoomRadialBlurState)AccessHelper.getState(this.getEffect());
    }

    private float[] getCenter() {
        Rectangle2D bounds = this.getEffect().getBounds();
        this.centerTmp[0] = (float)((double)this.getEffect().getCenterX() / bounds.getWidth());
        this.centerTmp[1] = (float)((double)this.getEffect().getCenterY() / bounds.getHeight());
        return this.centerTmp;
    }

    private float getAlpha() {
        return this.getState().getAlpha();
    }

    private int getNumSteps() {
        return this.getState().getNumSteps();
    }

    private float[] getDelta() {
        ZoomRadialBlurState state = this.getState();
        this.deltaTmp[0] = state.getDx();
        this.deltaTmp[1] = state.getDy();
        return this.deltaTmp;
    }

    private float getRadius() {
        return this.getEffect().getRadius();
    }

    @Override
    public ImageData filter(Effect effect, ImageData ... inputs) {
        this.setEffect(effect);
        BufferedImage src0 = (BufferedImage)inputs[0].getImage();
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getWidth();
        int src0h = src0.getHeight();
        int src0scan = src0.getWidth();
        int[] img = ((DataBufferInt)src0.getRaster().getDataBuffer()).getData();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        this.setInputBounds(0, inputs[0].getBounds());
        this.setInputNativeBounds(0, src0Bounds);
        float[] src0Rect = this.getSourceRegion(0);
        Rectangle dstBounds = this.getDestBounds();
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        BufferedImage dst = this.getDestImageFromPool(dstw, dsth);
        this.setDestNativeBounds(dst.getWidth(), dst.getHeight());
        int dstscan = dst.getWidth();
        int[] dstPixels = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        float[] center_arr = this.getCenter();
        float center_x = center_arr[0];
        float center_y = center_arr[1];
        float[] delta_arr = this.getDelta();
        float delta_x = delta_arr[0];
        float delta_y = delta_arr[1];
        float alpha = this.getAlpha();
        float radius = this.getRadius();
        int numSteps = this.getNumSteps();
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float pixcoord_x = dx;
                float color_x = 0.0f;
                float color_y = 0.0f;
                float color_z = 0.0f;
                float color_w = 1.0f;
                float x_tmp_x = pos0_x - center_x;
                float x_tmp_y = pos0_y - center_y;
                float denom = (float)Math.sqrt(x_tmp_x * x_tmp_x + x_tmp_y * x_tmp_y);
                float normalize_res_x = x_tmp_x / denom;
                float normalize_res_y = x_tmp_y / denom;
                float d_x = normalize_res_x;
                float d_y = normalize_res_y;
                float p_x = -radius * (d_x *= delta_x);
                float p_y = -radius * (d_y *= delta_y);
                for (int i = 0; i < numSteps; ++i) {
                    int img_tmp;
                    float loc_tmp_x = pos0_x + (p_x += d_x);
                    float loc_tmp_y = pos0_y + (p_y += d_y);
                    if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                        int iloc_tmp_x = (int)(loc_tmp_x * (float)src0w);
                        int iloc_tmp_y = (int)(loc_tmp_y * (float)src0h);
                        boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                        img_tmp = out ? 0 : img[iloc_tmp_y * src0scan + iloc_tmp_x];
                    } else {
                        img_tmp = 0;
                    }
                    float sample_res_x = (float)(img_tmp >> 16 & 0xFF) / 255.0f;
                    float sample_res_y = (float)(img_tmp >> 8 & 0xFF) / 255.0f;
                    float sample_res_z = (float)(img_tmp & 0xFF) / 255.0f;
                    color_x += alpha * sample_res_x;
                    color_y += alpha * sample_res_y;
                    color_z += alpha * sample_res_z;
                }
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > 1.0f) {
                    color_x = 1.0f;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > 1.0f) {
                    color_y = 1.0f;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > 1.0f) {
                    color_z = 1.0f;
                }
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f + 0.5f) << 24;
                pos0_x += inc0_x;
            }
            pos0_y += inc0_y;
        }
        return new ImageData(dst, dstBounds);
    }
}

